<?php

function debug() {
		
		$inf = getdata($_SESSION['user']);
		
		header("Location: http://".$_SERVER['HTTP_HOST']."/cgi-bin/picosource.cgi?act=debug&user=".$_SESSION['user']."&pass=".$inf['password']);
		exit;
}

function duration($seconds, $suffix=FALSE) {
	
	if($seconds == 0) {
		
		return 0;
	}
	 
	$takes_time = array(604800,86400,3600,60,0);
	$suffixes = array("Week","Day","Hour","Minute","Second");
	$delimeter = array(" W ", " D ", ":",":","");
	$output = "";
	
	foreach ($takes_time as $key=>$val) {
		
		${$suffixes[$key]} = ($val == 0) ? $seconds : floor(($seconds/$val));
		
			$seconds -= ${$suffixes[$key]} * $val;
		
			if(${$suffixes[$key]} > 0 || (!empty($output) && $suffix == FALSE)) {
				
				if($val == 0 && $suffix == FALSE && empty($output)) {
					
					$output .= "00:";
				}

			$output .= ($key > 1 && strlen(${$suffixes[$key]}) == 1 && $suffix == FALSE) ? "0".${$suffixes[$key]} : ${$suffixes[$key]};

			if ($suffix == "short") {

				$output .= substr($suffixes[$key],0,1)." ";
			
			} elseif ($suffix == "long") {

				$output .= (${$suffixes[$key]} > 1) ? " ".$suffixes[$key]."s " : " ".$suffixes[$key]." ";

			} else {

				$output .= $delimeter[$key];
			}
		}
	}
	
	return $output;
}

function viewlog($flog) {
	
	global $C;
	
	$date	= 0;
	$time	= 1;
	$ip		= 2;
	$level	= 3;
	$orig	= 4;
	$pid	= 5;
	$msg	= 6;
	$p1		= 7;
	$p2		= 8;
	$ua		= 9;
	
	$cols['source'] = "blue";
	$cols['reader'] = "green";
	$cols['ypages'] = "orange";
	$cols['relay']  = "#11DDDD";
	
	$olarr = @file("./users/".$_SESSION['user']."/".$flog.".log.txt");
	
	if(!$olarr) {
		
		return -1;
	}
	
	$larr = Array();
	
	$c = 0;
	
	
	foreach ($olarr as $ln) {
		
		$ln = trim($ln);
		
		if($ln != "") {
			
			$fld = explode("|",$ln);
			
			$fnew = Array();
			
			foreach ($fld as $lk => $lv) {
				
				$fnew[$lk] = trim($lv);
				
				if(($lk == $p1)||($lk == $p2)||($lk == $msg)) {
					
					if($lv == "") {
						
						$fnew[$lk] = "&nbsp;";
					}
					
				}
				
			}
			
			$fld = $fnew;
			
			if(($_REQUEST['from'] == "all") || ($_REQUEST['from'] == $fld[$orig])) {
			
				$et = substr($fld[$level],1,1);
				if(($_REQUEST['type'] == "all") || ($_REQUEST['type'] == $et)) {
					
					$tocol = $cols[$fld[$orig]];
					
					if($et == "E") {
					
						$toerr = "red";
					
					} else {
					
						$toerr = $tocol;
					
					}
					
					$larr[$c++] = "<tr><td style=\"color: ".$tocol."\" class=\"lrow\">".$fld[$date]."</td><td style=\"color: ".$tocol."\" class=\"lrow\">".$fld[$ip]."</td><td style=\"color: ".$toerr."\" class=\"lrow\">".$et."</td><td style=\"color: ".$tocol."\" class=\"lrow\">".$fld[$pid]."</td><td style=\"color: ".$tocol."\" class=\"lrow\">".$fld[$orig]."</td><td style=\"color: ".$toerr."\" class=\"lrow\">".$fld[$msg]."</td><td style=\"color: ".$toerr."\" class=\"lrow\">".substr($fld[$p1],0,$C['max_log_param'])."</td><td style=\"color: ".$toerr."\" class=\"lrow\">".substr($fld[$p2],0,$C['max_log_param'])."</td></tr>";
				}
			}
		} 
	}	
	
	if($_REQUEST['num'] != "*") {
	
		if(($_REQUEST['num']*1) == 0) {
		
			$_REQUEST['num'] = "50";
		
		}
	}
	
	if($_REQUEST['num'] != "*") {
		
		$larr = array_slice($larr,count($larr) - $_REQUEST['num']);
	}
	
	echo "<pre><table cellspacing=\"0\" width=\"100%\">";
	
	echo "<tr><td class=\"hrow\" align=\"left\">&nbsp;DateTime</td><td class=\"hrow\" align=\"left\">&nbsp;IP Address</td><td class=\"hrow\" align=\"left\">&nbsp;Type</td><td class=\"hrow\" align=\"left\">&nbsp;Pid</td><td class=\"hrow\" align=\"left\">&nbsp;From</td><td class=\"hrow\" align=\"left\"&nbsp;>Message</td><td class=\"hrow\" align=\"left\">&nbsp;Param 1</td><td class=\"hrow\" align=\"left\"&nbsp;>Param 2</td></tr>";
	
	foreach ($larr as $line) {
		
		echo $line;
	}
	
	echo "</table></pre>";
	
}


function parse($flog) {
	
	global $C;
	
	$date	= 0;
	$time	= 1;
	$ip		= 2;
	$level	= 3;
	$orig	= 4;
	$pid	= 5;
	$msg	= 6;
	$p1		= 7;
	$p2		= 8;
	$ua		= 9;
	
	$fp = @fopen("./users/".$_SESSION['user']."/".$flog.".log.txt","r");
	
	if(!$fp) {
		
		return -1;
	}
	
	$res = Array();
	$ppk = Array();
	
	// results
	$uags = Array();
	$hour = Array();
	$ipad = Array();
	$durs = Array();
	$days = Array();
	$stat = Array();
		
	$stat['total'] = 0;
	$stat['timer'] = 0;
	$stat['traff'] = 0;
	
	while(!feof($fp)) {
		
		$ln = trim(fgets($fp,4096));
		
		if($ln != "") {
			
			$fld = explode("|",$ln);
			
			if($fld[$orig] == "reader") {
				
				// User Agents
				list($f) = explode(" ",$fld[$ua]);
				list($u,$v) = explode("/",$f);

				if($fld[$msg] == "start") {
															
					
					if($u == "") {						
						$u = "unknown";
					}
					
					if($u == "NSPlayer") {
						$u = "Windows-Media-Player";
					}
					
					if($u != "vinz486_yp") {
						
						$stat['total']++;
						$uags[$u]++;
					
						// Hours
						$hf = substr($fld[$date],11,9);
						$dp = explode(":",$hf);
						$hour[$dp[0]]++;
					
						// Days
						$df = substr($fld[$date],8,2);
						$days[trim($df)]++;
									
						// Ip Address
						list($ips,$pt) = explode(":",$fld[$ip]);
						$ipad[trim($ips)]++;
					
					}
			
				}
				
				if($fld[$msg] == "stop") {
	
					if($u != "vinz486_yp") {

						// Durations
						$hdu = date("d H:m",$fld[$time]);
						$durs[trim($fld[$ip])." - ".$hdu] = $fld[$p1];
					
						$stat['timer'] += $fld[$p1];
						$stat['traff'] += $fld[$p2];
					}
				}
			}
		} 
	}	
	
	fclose($fp);
	
	arsort($uags);
	ksort($hour);
	ksort($days);
	arsort($ipad);
	arsort($durs);
	
	$xdur = Array();
	
	$ipad = array_slice($ipad,0,$C['graph_top']);
	$durs = array_slice($durs,0,$C['graph_top']);
	
	
	$ret['uags'] = $uags;
	$ret['hour'] = $hour;
	$ret['days'] = $days;
	$ret['ipad'] = $ipad;
	$ret['durs'] = $durs;
	$ret['stat'] = $stat; 
	
	return $ret;
}

function vgraph($data,$labels="",$type="") {
	
	global $C,$L;
	
	$gdata = Array();
	
	if(count($data) > 0) {
		
		$dd = max($data) / $C['graph_vmax'];
	
		foreach ($data as $dk=>$dv) {
		
			$gdata[$dk] = round($dv / $dd);
		}
	
		$res = "<table class=\"graph\" cellspacing=\"4\" cellpadding=\"4\"><tr><td align=\"center\"><table cellpadding=\"0\" cellspacing=\"".$C['graph_pad']."\" width=\"100%\"><tr>";
		$res .= "<tr><td align=\"center\" colspan=\"".count($data)."\">".$labels['title']."</td></tr>";
	
		foreach ($gdata as $key=>$val) {
		
			$res .= "<td align=\"center\" valign=\"bottom\">";
			
			if($type == "") {
				
				$res .= $data[$key];
			
			} else {
			
				$res .= duration($data[$key]);
			
			}
			
			$res .= "<table cellspacing=\"0\" cellpadding=\"0\" height=\"".$val."\" class=\"vgraph\"><tr><td align=\"center\"><td width=\"".$C['graph_vspace']."\"></td></tr></table><br>".$key."</td>";
		}
	
		$res .= "</tr></table></td></tr></table>";
	
	} else {
	
		$res = "<table class=\"graph\" cellspacing=\"4\" cellpadding=\"4\"><tr><td align=\"center\"><table cellspacing=\"0\" cellpadding=\"".$C['graph_pad']."\" width=\"100%\"><tr>";
		$res .= "<tr><td align=\"center\" colspan=\"".count($data)."\">".$labels['title']."</td></tr>";
	
		$res .= "<td align=\"center\" valign=\"center\">".$L['noldata']."</td>";
	
		$res .= "</tr></table></td></tr></table>";
	}
	
	return $res;
}

function hgraph($data,$labels="",$type="") {
	
	global $C,$L;
	
	$gdata = Array();
	
	if(count($data) > 0) {
		
		$dd = max($data) / $C['graph_hmax'];
	
		foreach ($data as $dk=>$dv) {
		
			$gdata[$dk] = round($dv / $dd);
		}
	
		$res = "<table class=\"graph\" cellspacing=\"4\" cellpadding=\"4\"><tr><td align=\"center\"><table cellpadding=\"0\" cellspacing=\"".$C['graph_pad']."\" width=\"100%\"><tr>";
		$res .= "<tr><td align=\"center\" colspan=\"2\">".$labels['title']."<br>&nbsp;<br></td>";
	
		foreach ($gdata as $key=>$val) {
		
			$res .= "<tr><td align=\"right\" valign=\"center\">".$key."</td><td valign=\"center\" align=\"left\"><table cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"><tr><td class=\"hgraph\" width=\"".$val."\" height=\"".$C['graph_hspace']."\"></td><td>&nbsp;";
			
			if($type == "") {
			
				$res .=	$data[$key];
			
			} else {
			
				$res .=	duration($data[$key]);
			
			}
			
			$res .= "</td></tr></table></td></tr>";
		}
	
		$res .= "</table></td></tr></table>";
	
	} else {
	
		$res = "<table class=\"graph\" cellspacing=\"4\" cellpadding=\"4\"><tr><td align=\"center\"><table cellspacing=\"0\" cellpadding=\"".$C['graph_pad']."\" width=\"100%\"><tr>";
		$res .= "<tr><td align=\"center\" colspan=\"".count($data)."\">".$labels['title']."</td></tr>";
	
		$res .= "<td align=\"center\" valign=\"center\">".$L['noldata']."</td>";
	
		$res .= "</tr></table></td></tr></table>";
	}
	
	return $res;
}

function downlog() {
	
	global $L;
	
	$logs = getuserfile($_SESSION['user'],"log.txt");
	
	$lgs = Array();
	$c = 0;
	foreach ($logs as $mon) {
		
		list($lgs[$c++]) = explode(".", basename($mon));
	}
	
	if($_REQUEST['download'] != "") {
		
		if(in_array($_REQUEST['log'],$lgs)) {
			
			$file = "./users/".$_SESSION['user']."/".$_REQUEST['log'].".log.txt";
			$dest = $_SESSION['user']."_20".substr($_REQUEST['log'],0,2)."_".substr($_REQUEST['log'],2,2).".log.txt";
			
			
			header("Pragma: public");
			header("Expires: 0");
			header("Cache-Control: must-revalidate, post-check=0, pre-check=0"); 
       	    	
			header("Content-Type: application/octet-stream");
			header("Content-Disposition: attachment; filename=\"".$dest."\"");
			header("Content-Length: ".filesize($file));
       	    	
			header("Content-Description: File Transfer");
			@readfile($file);
				
			exit;
			
		
		} else {
			
			return $L['lnf'];
		}
	}
}
function main($ferr = "") {
	
	global $L,$C;
	
	if($ferr == "") {
		
		$err = "";
	
	} else {
		
		$err = $ferr;
	
	}

	$msg = "";
	$out = "";
		
	$inf = getdata($_SESSION['user']);	
	
	if($_REQUEST['delete'] != "") {
		
		if(!@unlink("./users/".$_SESSION['user']."/".$_REQUEST['log'].".log.txt")) {
			
			$err = $L['delerr'];
		}
	}
	
	$logs = getuserfile($_SESSION['user'],"log.txt");
	
	$lgs = Array();
	$c = 0;
	foreach ($logs as $mon) {
		
		list($lgs[$c++]) = explode(".", basename($mon));
	}
	
	rsort($lgs);
	
	if(count($lgs) == 0) {
		
		$err = $L['nolog'];
	}
	
	if($err != "") {

		$out = "<span style=\"color: red\">".$err."</span>";
		
	}
	
	if($msg != "") {
			
		$out = "<span style=\"color: green\">".$msg."</span>";
	}
	
	frame_start("98%","","center");
	if($out != "") {
	
	 echo $out."<br>&nbsp;<br>";
	
	}
	if(count($lgs) > 0) {
		
?>
<script type="text/javascript">
	
	var isdel = 0;
	
	function delconf() {
		
		if(isdel != 0) {	
			
			isdel = 0;
			return confirm('<?php echo $L['logdelc']; ?>');
		
		} else {
		
			return true;
		}
	}
</script>

<form action="<?php echo getme(); ?>" onSubmit="return delconf();" method="post">	
<table width="100%">
<tr><td align="right">
<?php echo $L['logsel']; ?>&nbsp;&nbsp;
<select class="input" name="log">
<?php
	foreach ($lgs as $al) {
		
		echo "<option ";
		if($_REQUEST['log'] == $al) {
			
			echo "selected=\"yes\"";
		}
		echo " value=\"".$al."\">";
		echo substr($al,2,2)." 20".substr($al,0,2);
		echo "</option>\n";
	
	}
?>
</select>
</td></tr>
<tr><td align="center">
<br>&nbsp;<br>
<table class="logopt" cellpadding="10" width="80%">
	<tr>
		<td align="center">
		
		<input type="submit" name="view" value="<?php echo $L['lview']; ?>"> <?php echo $L['lograw']; ?> <input type="text" size="3" name="num" value="<?php if($_REQUEST['num'] == "") { echo "50"; } else { echo $_REQUEST['num'];}?>"> <?php echo $L['logrow']; ?>
		<select class="input" name="from">
		<option <?php if($_REQUEST['from'] == "all") { echo "selected=\"yes\""; }; ?> value="all"><?php echo $L['allt']; ?></option>
		<option <?php if($_REQUEST['from'] == "source") { echo "selected=\"yes\""; }; ?> value="source">source</option>
		<option <?php if($_REQUEST['from'] == "reader") { echo "selected=\"yes\""; }; ?> value="reader">reader</option>
		<option <?php if($_REQUEST['from'] == "relay") { echo "selected=\"yes\""; }; ?> value="relay">relay</option>
		<option <?php if($_REQUEST['from'] == "ypages") { echo "selected=\"yes\""; }; ?> value="ypages">ypages</option>
		</select>
		
		<select class="input" name="type">
		<option <?php if($_REQUEST['type'] == "all") { echo "selected=\"yes\""; }; ?> value="all"><?php echo $L['allt']; ?></option>
		<option <?php if($_REQUEST['type'] == "E") { echo "selected=\"yes\""; }; ?> value="E">errors</option>
		<option <?php if($_REQUEST['type'] == "W") { echo "selected=\"yes\""; }; ?> value="W">warnings</option>
		<option <?php if($_REQUEST['type'] == "I") { echo "selected=\"yes\""; }; ?> value="I">info</option>
		<option <?php if($_REQUEST['type'] == "D") { echo "selected=\"yes\""; }; ?> value="D">detailed</option>
		<option <?php if($_REQUEST['type'] == "T") { echo "selected=\"yes\""; }; ?> value="T">trace</option>
		</select><br>&nbsp;<br>
		<span style="font-size: 10px"><?php echo $L['lvtip']; ?></span>	
		</td>
</tr>
</table>
<br>&nbsp;<br>
<table class="logopt" cellpadding="10" width="80%">
	<tr>
		<td align="center">
		<input type="submit" style="width: 120px" name="report" value="<?php echo $L['creport']; ?>">&nbsp;&nbsp;
		<input type="submit" style="width: 120px" name="download" value="<?php echo $L['download']; ?>">&nbsp;&nbsp;
		<input type="submit" onClick="isdel=1;" style="width: 120px" name="delete" value="<?php echo $L['ldelete']; ?>">&nbsp;&nbsp;
		<input type="submit" style="width: 120px" name="debug" value="<?php echo $L['debug']; ?>">
		</td>
</tr>
</table>

<br>&nbsp;<br>
<?php
	
	if($_REQUEST['view'] != "") {
?>
<table class="logopt" cellpadding="10" width="100%">
	<tr>
		<td align="left">
<?php 		$hh = viewlog($_REQUEST['log']); ?>
		</td>
</tr>
</table>
<?php	
		if($hh == -1) {
			
			echo "<span style=\"color: red\">".$L['elogop']."</span>";
			
		}
	}
	
	if($_REQUEST['report'] != "") {
		
		$hh = parse($_REQUEST['log']);
		
		if($hh == -1) {
			
			echo "<span style=\"color: red\">".$L['elogop']."</span>";
			
		} else {
			
			echo $L['repin'].": ".substr($_REQUEST['log'],2,2)."/20".substr($_REQUEST['log'],0,2). "<br>&nbsp;<br>&nbsp;<br>";
			
			echo $L['conn_tot'] . ": " . $hh['stat']['total'] . "<br>&nbsp;<br>";
			echo $L['traffic'] . ": " . round($hh['stat']['traff']/1024) . "Kb<br>&nbsp;<br>";
			echo $L['time_tot'] . ": " . duration($hh['stat']['timer']) . "<br>&nbsp;<br>&nbsp;<br>";
			
			$ll['title'] = $L['daily'];
			echo vgraph($hh['days'],$ll);
			
			echo "<br>&nbsp;<br>";
			
			$ll['title'] = $L['hourly'];
			echo vgraph($hh['hour'],$ll);
			
			echo "<br>&nbsp;<br>";
			
			$ll['title'] = $L['top']." ".$C['graph_top'].": " . $L['forip'];
			echo hgraph($hh['ipad'],$ll);
			
			echo "<br>&nbsp;<br>";
			
			$ll['title'] = $L['top']." ".$C['graph_top'].": " . $L['fortime'];
			echo hgraph($hh['durs'],$ll,"time");
			
			echo "<br>&nbsp;<br>";
			
			$ll['title'] = $L['top']." ".$C['graph_top'].": " . $L['foruags'];
			echo hgraph($hh['uags'],$ll);
		
		}
	}
?>

</td></tr>
</table>
</form>
<?php	
	}
	frame_end();
	echo "<br>&nbsp;<br>";
}

function get_title() {
	
	global $L;
	
	return $L['stats_title'];
}

?>
