<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

print_cp_header($vbphrase['dbtech_vbshop_category_management']);

// Table header
$headings = array();
$headings[] = $vbphrase['dbtech_vbshop_category_name'];
$headings[] = $vbphrase['description'];
$headings[] = $vbphrase['display_order'];
$headings[] = preg_replace('/<dfn>.*<\/dfn>/isU', '', $vbphrase['dbtech_vbshop_shop_types']);
$headings[] = $vbphrase['edit_permissions'];

// Hook goes here

$headings[] = $vbphrase['edit'];
$headings[] = $vbphrase['delete'];


if (count($vbshop->cache['category']))
{
	print_form_header('vbshop', 'docategoryorder');	
	print_table_header($vbphrase['dbtech_vbshop_category_management'], count($headings));
	print_description_row($vbphrase['dbtech_vbshop_category_management_descr'], false, count($headings));	
	print_cells_row($headings, 0, 'thead');
	
	foreach ($vbshop->cache['category'] as $categoryid => $category)
	{
		$display = array();
		if ($category['shoptypes'] & 1)
		{
			$display[] = $vbphrase['dbtech_vbshop_itemshop'];
		}
		if ($category['shoptypes'] & 2)
		{
			$display[] = $vbphrase['dbtech_vbshop_giftshop'];
		}
		
		// Table data
		$cell = array();
		$cell[] = $category['title'];
		$cell[] = $category['description'];
		$cell[] = "<input type=\"text\" class=\"bginput\" name=\"order[$categoryid]\" value=\"$category[displayorder]\" tabindex=\"1\" size=\"3\" title=\"" . $vbphrase['edit_display_order'] . "\" />";
		$cell[] = implode('<br />', $display);
		$cell[] = construct_link_code($vbphrase['edit_permissions'], 'vbshop.php?' . $vbulletin->session->vars['sessionurl'] . 'do=categorypermissions&amp;categoryid=' . $categoryid);
		
		// Hook goes here
		
		$cell[] = construct_link_code($vbphrase['edit'], 'vbshop.php?' . $vbulletin->session->vars['sessionurl'] . 'do=modifycategory&amp;categoryid=' . $categoryid);
		$cell[] = construct_link_code($vbphrase['delete'], 'vbshop.php?' . $vbulletin->session->vars['sessionurl'] . 'do=deletecategory&amp;categoryid=' . $categoryid);
		
		// Print the data
		print_cells_row($cell, 0, 0, -5, 'middle', 0, 1);
	}
	print_submit_row($vbphrase['save_display_order'], false, count($headings), false, "<input type=\"button\" id=\"addnew\" class=\"button\" value=\"" . str_pad($vbphrase['dbtech_vbshop_add_new_category'], 8, ' ', STR_PAD_BOTH) . "\" tabindex=\"1\" onclick=\"window.location = 'vbshop.php?do=modifycategory'\" />");	
}
else
{
	print_form_header('vbshop', 'modifycategory');	
	print_table_header($vbphrase['dbtech_vbshop_category_management'], count($headings));
	print_description_row($vbphrase['dbtech_vbshop_no_categories'], false, count($headings));
	print_submit_row($vbphrase['dbtech_vbshop_add_new_category'], false, count($headings));	
}

print_cp_footer();

/*=======================================================================*\
|| ##################################################################### ||
|| # Created: 17:29, Sat Dec 27th 2008                                 # ||
|| # SVN: $RCSfile: category.php,v $ - $Revision: $WCREV$ $
|| ##################################################################### ||
\*=======================================================================*/
?>