<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

// Add to the navbits
$navbits[''] = $pagetitle = $vbulletin->options['dbtech_vbshop_shopname'];

// Grab category id
$categoryid = $vbulletin->input->clean_gpc('r', 'categoryid', TYPE_UINT);
$category = ($categoryid ? $vbshop->cache['category']["$categoryid"] : false);

// Grab shop type
$type = $vbulletin->input->clean_gpc('r', 'shoptype', TYPE_STR);
$type = ($type ? $type : 'item');

$lookup = array(
	'item' => 1,
	'gift' => 2
);

if ($category)
{
	// draw cp nav bar
	$vbshop->construct_nav('category_' . $type . '_' . $categoryid);
}
else
{
	// draw cp nav bar
	$vbshop->construct_nav('main');
}

$itemlist = array();
foreach ((array)$vbshop->cache["$type"] as $itemid => $item)
{
	$itemcat = $vbshop->cache['category']["$item[categoryid]"];
	if (!($itemcat['shoptypes'] & $lookup["$type"]) OR !$vbshop->check_permissions($vbulletin->userinfo, @unserialize($itemcat['permissions'])))
	{
		// This isn't to be displayed
		continue;
	}
	
	// Index by categoryid
	$itemlist["$item[categoryid]"]["$itemid"] = $item;
}

// Ensure our purchases cache is up to specs
$vbshop->verify_purchases($vbulletin->userinfo);

// Store better purchases cache
$purchase = array(
	'item' => array(),
	'gift' => array(),
);

foreach ($vbulletin->userinfo['dbtech_vbshop_purchase'] as $purchaseid => $purchases)
{
	if ($purchases['buyer'] != $vbulletin->userinfo['userid'])
	{
		// Gtfo
		continue;
	}
	
	if (!$purchase["$purchases[feature]"]["$purchases[featureid]"] OR $purchase["$purchases[feature]"]["$purchases[featureid]"] < $purchase['dateline'])
	{
		// Store dateline
		$purchase["$purchases[feature]"]["$purchases[featureid]"] = $purchases['dateline'];
	}
}

if (count($itemlist))
{
	if (intval($vbulletin->versionnumber) == 3)
	{
		$HTML = '<table class="tborder" cellpadding="' . $stylevar['cellpadding'] . '" cellspacing="' . $stylevar['cellspacing'] . '" width="100%" border="0">';
	}

	$wrapper = '';
	
	$page_templater = vB_Template::create('dbtech_vbshop_wrapper');
		$page_templater->register('title', $vbphrase["dbtech_vbshop_{$type}shop"]);
		$page_templater->register('description', $vbphrase["dbtech_vbshop_{$type}shop_descr"]);
		$page_templater->register('type', $type);
	
	foreach ($itemlist as $categoryid => $items)
	{
		if ($category AND $categoryid != $category['categoryid'])
		{
			// We're only browsing one category
			continue;
		}
		
		$templater = vB_Template::create('dbtech_vbshop_categorybits');
			$templater->register('expand', true);
			$templater->register('category', $vbshop->cache['category']["$categoryid"]);
		
		$contents = '';
		foreach ($items as $itemid => $item)
		{
			// Init the object
			$item_obj = $vbshop->init_item($item);
			
			// Condition data
			$conditions = array();
			$conditions[] = construct_phrase($vbphrase['dbtech_vbshop_item_cost_x'], vb_number_format(round($item['price'], 2)), $vbulletin->options['dbtech_vbshop_pointsname']);
			
			if ($vbulletin->userinfo['userid'])
			{
				// Only registered users have points
				if ($item['price'] <= $userpoints AND $item_obj->check_permissions($vbulletin->userinfo))
				{
					// We can afford it
					$conditions[] = '<input type="submit" class="button" name="' . $type . '[' . $itemid . ']" value="' . $vbphrase['dbtech_vbshop_purchase'] . '" />';
				}
			}
								
			// Check if we've earned this purchase or not
			if ($purchase["$type"]["$itemid"])
			{
				// Store time earned
				$conditions[] = '<span class="smallfont">' . construct_phrase($vbphrase['dbtech_vbshop_item_bought_x'], vbdate($vbulletin->options['timeformat'], $purchase["$type"]["$itemid"]) . ' ' . vbdate($vbulletin->options['dateformat'], $purchase["$type"]["$itemid"])) . '</span>';
			}
			
			$conditions[] = '<span class="smallfont">' . construct_phrase($vbphrase['dbtech_vbshop_total_purchases_x'], vb_number_format($item['purchases'])) . '</span>';
			
			$templaterr = vB_Template::create('dbtech_vbshop_contentbits');
				$templaterr->register('icon', ($item['shopicon'] ? '<img src="dbtech/vbshop/images/' . $item['shopicon'] . '" alt="' . $item['title'] . '" /> ' : '') . '<b style="vertical-align:top;">' . $item['title'] . '</b>');
				$templaterr->register('description', $item['description']);
				$templaterr->register('conditions', implode('<br />', $conditions));
			$contents .= $templaterr->render();
		}
			$templater->register('contents', $contents);
		$wrapper .= $templater->render();
	}
		$page_templater->register('wrapper', $wrapper);
	$HTML .= $page_templater->render();

	if (intval($vbulletin->versionnumber) == 3)
	{
		$HTML .= '</table>';
	}
}
else
{
	$HTML = $vbphrase['dbtech_vbshop_no_items_frontend'];
}

/*======================================================================*\
|| #################################################################### ||
|| # Created: 22:38, Sun Sep 7th 2008								  # ||
|| # SVN: $Rev$									 					  # ||
|| #################################################################### ||
\*======================================================================*/
?>