<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

$items_by_category 	= array();
foreach ((array)$vbshop->cache['item'] as $itemid => $item)
{
	// Index by categoryid
	$items_by_category["$item[categoryid]"]["$itemid"] = $item;
}

print_cp_header($vbphrase['dbtech_vbshop_item_management']);

// Table header
$headings = array();
$headings[] = $vbphrase['title'];
$headings[] = $vbphrase['dbtech_vbshop_shop_icon'];
$headings[] = $vbphrase['description'];
$headings[] = preg_replace('/<dfn>.*$/isU', '', $vbphrase['dbtech_vbshop_item_type']);
$headings[] = $vbphrase['display_order'];
$headings[] = $vbphrase['dbtech_vbshop_item_price'];
$headings[] = preg_replace('/<dfn>.*$/isU', '', $vbphrase['dbtech_vbshop_item_giftable']);
$headings[] = $vbphrase['edit_permissions'];

// Hook goes here

$headings[] = $vbphrase['edit'];
$headings[] = $vbphrase['delete'];

$itemtypes = array();
if ($handle = opendir('dbtech/vbshop/items'))
{
	while (false !== ($file = readdir($handle)))
	{
		if ($file != '.' AND $file != '..' AND $file != 'index.html')
		{
			// Strip extenshun
			$file = substr($file, 0, strrpos($file, '.'));
			
			// Load the item info
			$item = $vbshop->init_item(array('itemtype' => $file))->load_item_info();
			
			if ($item['name'])
			{
				// Store the icon
				$itemtypes["$file"] = $item['name'];
			}
		}
	}
	closedir($handle);
}

// Sort the array as a string
asort($itemtypes, SORT_STRING);	

print_form_header('vbshop', 'modifyitem');	
print_table_header($vbphrase['dbtech_vbshop_item_management'], count($headings));
if (empty($itemtypes))
{
	print_description_row($vbphrase['dbtech_vbshop_no_items'], false, count($headings));
	print_table_footer();
}
else
{
	print_select_row($vbphrase['dbtech_vbshop_item_type'], 'itemtype', $itemtypes);
	print_submit_row($vbphrase['dbtech_vbshop_add_new_item'], false, count($headings));
}

if (count($items_by_category))
{
	print_form_header('vbshop', 'doitemorder');	
	print_table_header($vbphrase['dbtech_vbshop_item_management'], count($headings));
	print_description_row($vbphrase['dbtech_vbshop_item_management_descr'], false, count($headings));	
	
	foreach ($items_by_category as $categoryid => $items)
	{
		print_description_row($vbshop->cache['category']["$categoryid"]['title'], false, count($headings), 'optiontitle');
		print_description_row($vbshop->cache['category']["$categoryid"]['description'], false, count($headings));	
		print_cells_row($headings, 0, 'thead');
		
		foreach ($items as $itemid => $item)
		{
			// Table data
			$cell = array();
			$cell[] = $item['title'];
			$cell[] = ($item['shopicon'] ? '<img src="../dbtech/vbshop/images/' . $item['shopicon'] . '" alt="' . $item['title'] . '" /> ' : 'N/A');
			$cell[] = $item['description'];
			$cell[] = $item['itemtype'];
			$cell[] = "<input type=\"text\" class=\"bginput\" name=\"order[$itemid]\" value=\"$item[displayorder]\" tabindex=\"1\" size=\"3\" title=\"" . $vbphrase['edit_display_order'] . "\" />";
			$cell[] = vb_number_format(round($item['price'], 2)) . ' ' . $vbulletin->options['dbtech_vbshop_pointsname'];
			$cell[] = ($item['giftable'] ? $vbphrase['yes'] : $vbphrase['no']);
			$cell[] = construct_link_code($vbphrase['edit_permissions'], 'vbshop.php?' . $vbulletin->session->vars['sessionurl'] . 'do=itempermissions&amp;itemid=' . $itemid);

			// Hook goes here
			
			$cell[] = construct_link_code($vbphrase['edit'], 'vbshop.php?' . $vbulletin->session->vars['sessionurl'] . 'do=modifyitem&amp;itemid=' . $itemid);
			$cell[] = construct_link_code($vbphrase['delete'], 'vbshop.php?' . $vbulletin->session->vars['sessionurl'] . 'do=deleteitem&amp;itemid=' . $itemid);
			
			// Print the data
			print_cells_row($cell, 0, 0, -5, 'middle', 0, 1);
		}
	}
	
	print_submit_row($vbphrase['save_display_order'], false, count($headings));	
}

print_cp_footer();

/*=======================================================================*\
|| ##################################################################### ||
|| # Created: 17:29, Sat Dec 27th 2008                                 # ||
|| # SVN: $RCSfile: item.php,v $ - $Revision: $WCREV$ $
|| ##################################################################### ||
\*=======================================================================*/
?>