<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
// filter functionality class

/**
* Class that handles filtering arrays
*
* @package	Framework
* @version	$ $Rev$ $
* @date		$ $Date$ $
*/
class DBTech_Framework_Filter
{
	/**
	* Id Field we are using
	*
	* @private	string
	*/	
	private $idfield 	= NULL;
	
	/**
	* Id value we are looking for
	*
	* @private	mixed
	*/	
	private $idval 		= NULL;
	
	
	
	/**
	* Constructor. Captures the argument from the constructing function
	* and passes it along to the initialiser.
	*
	* @return	void		Nothing
	*/
	public function __construct()
	{
		// Tarp the argument array
		$args = func_get_arg(0);
		
		// Get rid of the class name, we don't need their kind around here
		unset($args[0]);
		
		// Now initialise everything
		call_user_func_array(array($this, 'init'), $args);
	}
	
	/**
	* Initialises 
	*
	* @return	void		Nothing
	*/
	private function init() { }
	
	/**
	* Sets up and begins the filtering process 
	*
	* @param	array	Array to filter
	* @param	string	What the ID Field is
	* @param	mixed	What we are looking for
	*
	* @return	array	Filtered array
	*/
	public function filter($array, $idfield, $idval)
	{
		// Set the two things we can't pass on to the callback
		$this->idfield 	= $idfield;
		$this->idval	= $idval;
		
		// Filter this shiet
		return array_filter($array, array($this, 'do_filter'));
	}
	
	/**
	* Checks if this element should be included
	*
	* @param	array	Array to filter
	*
	* @return	boolean	Whether we should include this or not
	*/	
	protected function do_filter($array)
	{
		return ($array["{$this->idfield}"] == $this->idval);
	}
}