<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'vbshop');
define('VBSHOP_PRO', (file_exists('./includes/xml/bitfield_dbtech_vbshop_pro.xml') ? true : false));

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('vbshop', 'user', 'album');

// get templates used by all actions
$globaltemplates = array(
	'dbtech_vbshop',
	'dbtech_vbshop_nav_categorybit',
);

// pre-cache templates used by specific actions
$actiontemplates = array(
	'main' => array(
		'dbtech_vbshop_wrapper',
		'dbtech_vbshop_categorybits',
		'dbtech_vbshop_contentbits',
	),
	'shop' => array(
		'dbtech_vbshop_wrapper',
		'dbtech_vbshop_categorybits',
		'dbtech_vbshop_contentbits',
	),
	'purchase' => array(
		'dbtech_vbshop_purchase',
		'dbtech_vbshop_purchase_style',
		'dbtech_vbshop_purchase_usernamechange',
		'dbtech_vbshop_purchase_usertitlechange',
		'dbtech_vbshop_purchase_lottery',
		'dbtech_vbshop_purchase_lottery_number',
	),
	'purchasehistory' => array(
		'dbtech_vbshop_purchasehistory',
		'dbtech_vbshop_daybit',
		'dbtech_vbshop_entrybit',
	),
	'donate' => array(
		'dbtech_vbshop_donate',
	),
	'bank'	=> array(
		'dbtech_vbshop_bank',
	),
	'steal'	=> array(
		'dbtech_vbshop_steal',
	),
	'dosteal' => array(
		'dbtech_vbshop_steal_report'
	)
);

// get special data templates from the datastore
require_once('./dbtech/vbshop/includes/specialtemplates.php');
$specialtemplates = $extracache;

// ############################### default do value ######################
if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = $_GET['do'] = 'main';
}

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

if (!empty($_POST['do']))
{
	// $_POST requests take priority
	$action = $_POST['do'];
}
else if (!empty($_GET['do']))
{
	// We had a GET request instead
	$action = $_GET['do'];
}
else
{
	// No request
	$action = 'main';
}

// Strip non-valid characters
$action = preg_replace("/[^a-zA-Z0-9-_]/", "", $action);

if (!$vbulletin->options['dbtech_vbshop_active'] AND !$vbshop->permissions['ismanager'])
{
	// Sb is shut off
	eval(standard_error($vbulletin->options['dbtech_vbshop_closedreason']));
}

if (!$vbshop->permissions['canview'])
{
	// Can't view Activity
	print_no_permission();
}

// begin navbits
$navbits = array('vbshop.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['dbtech_vbshop_vbshop']);

// Grab userpoints
$userpoints = $vbulletin->userinfo["{$vbulletin->options[dbtech_vbshop_pointsfield]}"];

if (!file_exists(DIR . '/dbtech/vbshop/actions/' . $action . '.php'))
{
	if (!file_exists(DIR . '/dbtech/vbshop_pro/actions/' . $action . '.php'))
	{
		// Throw error from invalid action
		eval(standard_error(fetch_error('dbtech_vbshop_error_x', $vbphrase['dbtech_vbshop_invalid_action'])));
	}
	else
	{
		// Include the selected file
		include_once(DIR . '/dbtech/vbshop_pro/actions/' . $action . '.php');	
	}
}
else
{
	// Include the selected file
	include_once(DIR . '/dbtech/vbshop/actions/' . $action . '.php');	
}

if (intval($vbulletin->versionnumber) == 3)
{
	// Create navbits
	$navbits = construct_navbits($navbits);	
	eval('$navbar = "' . fetch_template('navbar') . '";');
}
else
{
	$navbar = render_navbar_template(construct_navbits($navbits));	
}

$categories = array();
foreach (array(1 => 'item', 2 => 'gift') as $typeid => $type)
{
	$categories["$type"] = '';
	foreach ((array)$vbshop->cache['category'] as $categoryid => $category)
	{
		if (!($category['shoptypes'] & $typeid) OR !$vbshop->check_permissions($vbulletin->userinfo, @unserialize($category['permissions'])))
		{
			// Gtfo
			continue;
		}
		
		$templater = vB_Template::create('dbtech_vbshop_nav_categorybit');
			$templater->register('categoryid', 	$categoryid);
			$templater->register('navclass', 	$navclass["category_{$type}_{$categoryid}"]);
			$templater->register('title', 		$category['title']);
			$templater->register('shoptype', 	$type);
		$categories["$type"] .= $templater->render();
	}
}

// Finish the main template
$templater = vB_Template::create('dbtech_vbshop');
	$templater->register_page_templates();
	$templater->register('navclass', 				$navclass);
	$templater->register('HTML', 					$HTML);
	$templater->register('navbar', 					$navbar);
	$templater->register('pagetitle', 				$pagetitle);
	$templater->register('pagedescription', 		$pagedescription);
	$templater->register('template_hook', 			$template_hook);
	$templater->register('includecss', 				$includecss);
	$templater->register('categories',				$categories);
	$templater->register('userpoints',				vb_number_format(round($userpoints, 2)) . ' ' . $vbulletin->options['dbtech_vbshop_pointsname']);
	$templater->register('VBSHOP_VERSION',			VBSHOP_VERSION);
	$templater->register('VBSHOP_VERSIONNUMBER', 	VBSHOP_VERSIONNUMBER);
print_output($templater->render());

/*=======================================================================*\
|| ##################################################################### ||
|| # Created: 17:29, Sat Dec 27th 2008                                 # ||
|| # SVN: $RCSfile: vbshop.php,v $ - $Revision: $WCREV$ $
|| ##################################################################### ||
\*=======================================================================*/
?>