<?php

/**
 * @package : PowerBBCode
 * @copyright : MaaSTaaR And abu Rakan >
 * @version : 1.1 Special verion for PowerBB
 * @start : 23/2/2006 , 3:46 PM (kuwait : GMT+3)
 * @end   : 23/2/2006 , 6:30 PM (kuwait : GMT+3)
 * @last update : 29/8/2010 02:41:55 AM
 */

class PowerBBCodeParse
{
 	/**
 	 * Search some text in $string and change it to other text
 	 *
 	 * @param :
 	 *				$string -> the text
 	 */
 	function replace($string)
 	{
 		global $PowerBB;



 		$brackets = (strpos($string,'[') !== false) and (strpos($string,']') !== false);

 		if ($brackets)
 		{
 			$string = htmlspecialchars($string);

 			$first_search = array();
 			$first_replace = array();

            $first_search['[code]'] = '#\[code\](.*)\[/code\]#esiU';
            $first_replace['[code]'] = "\$this->PowerCode_Code('\\1')";

            $first_search['[php]'] = '#\[php\](.*)\[/php\]#esiU';
            $first_replace['[php]'] = "\$this->PowerCode_Code('\\1')";

 			$string = preg_replace($first_search,$first_replace,$string);

 			$search_array = array();
 			$replace_array = array();

             //replace

            $search_array['[img]'] = '#\[img\](.*)\[/img\]#esiU';
            $replace_array['[img]'] = "\$this->resize_image('\\1')";

            $search_array['[IMG]'] = '#\[IMG\]\s*(https?://([^<>*"]+|[a-z0-9/\\._\- !]+))\[/IMG\]#iUe';
            $replace_array['[IMG]'] = "\$this->resize_image('\\1', '\\1')";

            $search_array['[b]'] = '#\[b\](.*)\[/b\]#esiU';
            $replace_array['[b]'] = "\$this->PowerCode_Tag('b', '\\1')";

            $search_array['[u]'] = '#\[u\](.*)\[/u\]#esiU';
            $replace_array['[u]'] = "\$this->PowerCode_Tag('u', '\\1')";

            $search_array['[i]'] = '#\[i\](.*)\[/i\]#esiU';
            $replace_array['[i]'] = "\$this->PowerCode_Tag('i', '\\1')";

            $search_array['[right]'] = '#\[right\](.*)\[/right\]#esiU';
            $replace_array['[right]'] = "\$this->PowerCode_Tag('p', '\\1', ' align=\"right\"')";

            $search_array['[left]'] = '#\[left\](.*)\[/left\]#esiU';
            $replace_array['[left]'] = "\$this->PowerCode_Tag('p', '\\1', ' align=\"left\"')";

            $search_array['[justify]'] = '#\[justify\](.*)\[/justify\]#esiU';
            $replace_array['[justify]'] = "\$this->PowerCode_Tag('p', '\\1', ' align=\"justify\"')";

            $search_array['[JUSTIFY]'] = '#\[JUSTIFY\](.*)\[/JUSTIFY\]#esiU';
            $replace_array['[JUSTIFY]'] = "\$this->PowerCode_Tag('p', '\\1', ' align=\"justify\"')";

            $search_array['[center]'] = '#\[center\](.*)\[/center\]#esiU';
            $replace_array['[center]'] = "\$this->PowerCode_Tag('p', '\\1', ' align=\"center\"')";

            $search_array['[font='] = '#\[font=(.*)\](.*)\[/font\]#esiU';
            $replace_array['[font='] = "\$this->PowerCode_Tag('font', '\\2', ' face=\"\\1\"')";

            $search_array['[color='] = '#\[color=(.*)\](.*)\[/color\]#esiU';
            $replace_array['[color='] = "\$this->PowerCode_Tag('font', '\\2', ' color=\"\\1\"')";

            $search_array['[quote='] = '#\[quote=(.*)\](.*)\[/quote\]#esiU';
            $replace_array['[quote='] = "\$this->PowerCode_Quote('\\2', '\\1')";

            $search_array['[quote]'] = '#\[quote\](.*)\[/quote\]#esiU';
            $replace_array['[quote]'] = "\$this->PowerCode_Quote('\\1')";

            $search_array['[qu]'] = '#\[qu\](.*)\[/qu\]#esiU';
            $replace_array['[qu]'] = "\$this->PowerCode_Quote('\\1')";

            $search_array['[youtube]'] = '#\[youtube\](.*)\[/youtube\]#esiU';
            $replace_array['[youtube]'] = "\$this->PowerCode_Youtube('\\1', '\\1')";

            $search_array['[youtube='] = '#\[youtube=(.*)\](.*)\[/youtube\]#esiU';
            $replace_array['[youtube='] = "\$this->PowerCode_Youtube('\\1', '\\2')";

            $search_array['[media]'] = '#\[media\](.*)\[/media\]#esiU';
            $replace_array['[media]'] = "\$this->PowerCode_Media('\\1', '\\1')";

            $search_array['[media='] = '#\[media=(.*)\](.*)\[/media\]#esiU';
            $replace_array['[media='] = "\$this->PowerCode_Media('\\1', '\\2')";

            $search_array['[ram]'] = '#\[ram\](.*)\[/ram\]#esiU';
            $replace_array['[ram]'] = "\$this->PowerCode_Ram('\\1', '\\1')";

            $search_array['[ram='] = '#\[ram=(.*)\](.*)\[/ram\]#esiU';
            $replace_array['[ram='] = "\$this->PowerCode_Ram('\\1', '\\2')";

            $search_array['[Flash='] = '#\[flash=(&quot;|"|\'|)(.*)\\1\](height=)\\1([0-9]+)\\1[ ]+(width=)\\1([0-9]+)\\1\[/flash\]#esiU';
            $replace_array['[Flash='] = "\$this->PowerCode_Flash('\\2', '\\6','\\4', 'flash')";

            $search_array['[Flash='] = '#\[flash=(&quot;|"|\'|)(.*)\\1\]([w|W][i|I][d|D][t|T][h|H][=])\\1([0-9]+)\\1[ ]+([h|H][e|E][i|I][g|G][h|H][t|T][=])\\1([0-9]+)\\1\[/flash\]#esiU';
            $replace_array['[Flash='] = "\$this->PowerCode_Flash('\\2', '\\6','\\4', 'flash')";

      	    $search_array['[s]'] = '#\[s\](.*)\[/s\]#esiU';
            $replace_array['[s]'] = "\$this->PowerCode_Tag('s', '\\1')";

            $search_array['[h1]'] = '#\[h1\](.*)\[/h1\]#esiU';
            $replace_array['[h1]'] = "\$this->PowerCode_Tag('h1', '\\1')";

            $search_array['[hr]'] = '#\[hr\](.*)\[/hr\]#esiU';
            $replace_array['[hr]'] = "\$this->PowerCode_Tag('span', '<HR id=null>')";

            $search_array['[sub]'] = '#\[sub\](.*)\[/sub\]#esiU';
            $replace_array['[sub]'] = "\$this->PowerCode_Tag('SUB', '\\1')";

            $search_array['[sup]'] = '#\[sup\](.*)\[/sup\]#esiU';
            $replace_array['[sup]'] = "\$this->PowerCode_Tag('SUP', '\\1')";

            $search_array['[table]'] = '#\[table\](.*)\[/table\]#esiU';
            $replace_array['[table]'] = "\$this->PowerCode_table('\\1')";

            $search_array['[tr]'] = '#\[tr\](.*)\[/tr\]#esiU';
            $replace_array['[tr]'] = "\$this->PowerCode_tr('\\1')";

            $search_array['[td]'] = '#\[td\](.*)\[/td\]#esiU';
            $replace_array['[td]'] = "\$this->PowerCode_td('\\1')";

            $search_array['[th]'] = '#\[th\](.*)\[/th\]#esiU';
            $replace_array['[th]'] = "\$this->PowerCode_th('\\1')";

            $search_array['[url]'] = '#\[url\](.*)\[/url\]#esiU';
            $replace_array['[url]'] = "\$this->PowerCode_Tag_Url('\\1', '\\1')";

            $search_array['[url='] = '#\[url=(.*)\](.*)\[/url\]#esiU';
            $replace_array['[url='] = "\$this->PowerCode_Tag_Url('\\1', '\\2')";

            $search_array['[size='] = '#\[size=(.*)\](.*)\[/size\]#esiU';
            $replace_array['[size='] = "\$this->PowerCode_Tag('font', '\\2', ' size=\"\\1\"')";

            $search_array['[list='] = '#\[list=(1|2)\](.*?)\[/list\]#esiU';
            $replace_array['[list='] = "\$this->DoList('$1','$2')";

            $search_array['[list'] = '#\[list\](.*?)\[/list\]#esiU';
            $replace_array['[list'] = "\$this->DoList('2','$1')";

            $search_array['[guest_name]'] = '#\[guest_name\](.*)\[/guest_name\]#esiU';
            $replace_array['[guest_name]'] = "\$this->PowerCode_Tag('br', '\\1' )";

            $Guest_message = ($PowerBB->_CONF['info_row']['guest_message_for_haid_links']);
			if ($PowerBB->_CONF['info_row']['haid_links_for_guest'] == 0)
			{
			//start_replace_links_reply
			$search_array[] = ",([^]_a-z0-9-=\"'\/])((https?|ftp|gopher|news|telnet):\/\/)([^ \r\n\(\)\*\^\$!`\"'\|\[\]\{\}<>]*),i";
			$replace_array[] = '<a href="$2$4" target="_blank">$2$4</a>';
			$search_array[] = ",^((https?|ftp|gopher|news|telnet):\/\/|\.)([^ \r\n\(\)\*\^\$!`\"'\|\[\]\{\}<>]*),i";
			$replace_array[] = '<a href="$1$3" target="_blank">$1$3</a>';
			$search_array[] = ",([^]_a-z0-9-=\"'\/])((ftp|gopher|news|telnet):\/\/|www\.)([^ \r\n\(\)\*\^\$!`\"'\|\[\]\{\}<>]*),i";
			$replace_array[] = '<a href="http://$2$4" target="_blank">$2$4</a>';
			$search_array[] = "/^([\\._a-zA-Z0-9-]+(\.[\\._a-zA-Z0-9-]+)*@[a-zA-Z0-9-]+(\.[a-zA-Z0-9-]+)*(\.[a-zA-Z]{2,3}))/i";
			$replace_array[] = '<a href="mailto:$1">$1</a>';
			//end_replace_links_reply
			 }
			else
			{
            $Guest_message = ($PowerBB->_CONF['info_row']['guest_message_for_haid_links']);
            $register_link = ('index.php?page=register&index=1');
                if ($PowerBB->_CONF['member_permission'])
				{
				//start_replace_links_reply
				$search_array[] = ",([^]_a-z0-9-=\"'\/])((https?|ftp|gopher|news|telnet):\/\/)([^ \r\n\(\)\*\^\$!`\"'\|\[\]\{\}<>]*),i";
				$replace_array[] = '<a href="$2$4" target="_blank">$2$4</a>';
				$search_array[] = ",^((https?|ftp|gopher|news|telnet):\/\/|\.)([^ \r\n\(\)\*\^\$!`\"'\|\[\]\{\}<>]*),i";
				$replace_array[] = '<a href="$1$3" target="_blank">$1$3</a>';
				$search_array[] = ",([^]_a-z0-9-=\"'\/])((ftp|gopher|news|telnet):\/\/|www\.)([^ \r\n\(\)\*\^\$!`\"'\|\[\]\{\}<>]*),i";
				$replace_array[] = '<a href="http://$2$4" target="_blank">$2$4</a>';
				$search_array[] = "/^([\\._a-zA-Z0-9-]+(\.[\\._a-zA-Z0-9-]+)*@[a-zA-Z0-9-]+(\.[a-zA-Z0-9-]+)*(\.[a-zA-Z]{2,3}))/i";
				$replace_array[] = '<a href="mailto:$1">$1</a>';
				}
                if (!$PowerBB->_CONF['member_permission'])
				{
			    //end_replace_links_reply
				$search_array[] = ",([^]_a-z0-9-=\"'\/])((https?|ftp|gopher|news|telnet):\/\/)([^ \r\n\(\)\*\^\$!`\"'\|\[\]\{\}<>]*),i";
				$replace_array[] = "<a href=\"$register_link\" target=\"_blank\">$Guest_message</a>";
				$search_array[] = ",^((https?|ftp|gopher|news|telnet):\/\/|\.)([^ \r\n\(\)\*\^\$!`\"'\|\[\]\{\}<>]*),i";
				$replace_array[] = "<a href=\"$register_link\" target=\"_blank\">$Guest_message</a>";
				$search_array[] = ",([^]_a-z0-9-=\"'\/])((ftp|gopher|news|telnet):\/\/|www\.)([^ \r\n\(\)\*\^\$!`\"'\|\[\]\{\}<>]*),i";
				$replace_array[] = "<a href=\"$register_link\" target=\"_blank\">$Guest_message</a>";
				$search_array[] = "/^([\\._a-zA-Z0-9-]+(\.[\\._a-zA-Z0-9-]+)*@[a-zA-Z0-9-]+(\.[a-zA-Z0-9-]+)*(\.[a-zA-Z]{2,3}))/i";
				$replace_array[] = "<a href=\"$register_link\" target=\"_blank\">$Guest_message</a>";
				//end_replace_links_reply
			    }
            }


 			$string = preg_replace($search_array,$replace_array,$string);




                        foreach($search_array AS $tag => $regex)
                        {
                                while (stristr($string, $tag) !== false)
                                {
                                        $text = $string;
                                        $string = preg_replace($regex, $replace_array["$tag"], $string);
                                        if ($text == $string)
                                        {
                                                break;
                                        }
                                }
                        }
                }
 		else
 		{
           $Guest_message = ($PowerBB->_CONF['info_row']['guest_message_for_haid_links']);
			if ($PowerBB->_CONF['info_row']['haid_links_for_guest'] == 0)
			{
			//start_replace_links_reply
			$search_array[] = ",([^]_a-z0-9-=\"'\/])((https?|ftp|gopher|news|telnet):\/\/)([^ \r\n\(\)\*\^\$!`\"'\|\[\]\{\}<>]*),i";
			$replace_array[] = '<a href="$2$4" target="_blank">$2$4</a>';
			$search_array[] = ",^((https?|ftp|gopher|news|telnet):\/\/|\.)([^ \r\n\(\)\*\^\$!`\"'\|\[\]\{\}<>]*),i";
			$replace_array[] = '<a href="$1$3" target="_blank">$1$3</a>';
			$search_array[] = ",([^]_a-z0-9-=\"'\/])((ftp|gopher|news|telnet):\/\/|www\.)([^ \r\n\(\)\*\^\$!`\"'\|\[\]\{\}<>]*),i";
			$replace_array[] = '<a href="http://$2$4" target="_blank">$2$4</a>';
			$search_array[] = "/^([\\._a-zA-Z0-9-]+(\.[\\._a-zA-Z0-9-]+)*@[a-zA-Z0-9-]+(\.[a-zA-Z0-9-]+)*(\.[a-zA-Z]{2,3}))/i";
			$replace_array[] = '<a href="mailto:$1">$1</a>';
			//end_replace_links_reply
			 }
			else
			{
            $Guest_message = ($PowerBB->_CONF['info_row']['guest_message_for_haid_links']);
            $register_link = ('index.php?page=register&index=1');
                if ($PowerBB->_CONF['member_permission'])
				{
				//start_replace_links_reply
				$search_array[] = ",([^]_a-z0-9-=\"'\/])((https?|ftp|gopher|news|telnet):\/\/)([^ \r\n\(\)\*\^\$!`\"'\|\[\]\{\}<>]*),i";
				$replace_array[] = '<a href="$2$4" target="_blank">$2$4</a>';
				$search_array[] = ",^((https?|ftp|gopher|news|telnet):\/\/|\.)([^ \r\n\(\)\*\^\$!`\"'\|\[\]\{\}<>]*),i";
				$replace_array[] = '<a href="$1$3" target="_blank">$1$3</a>';
				$search_array[] = ",([^]_a-z0-9-=\"'\/])((ftp|gopher|news|telnet):\/\/|www\.)([^ \r\n\(\)\*\^\$!`\"'\|\[\]\{\}<>]*),i";
				$replace_array[] = '<a href="http://$2$4" target="_blank">$2$4</a>';
				$search_array[] = "/^([\\._a-zA-Z0-9-]+(\.[\\._a-zA-Z0-9-]+)*@[a-zA-Z0-9-]+(\.[a-zA-Z0-9-]+)*(\.[a-zA-Z]{2,3}))/i";
				$replace_array[] = '<a href="mailto:$1">$1</a>';
				}
                if (!$PowerBB->_CONF['member_permission'])
				{
			    //end_replace_links_reply
				$search_array[] = ",([^]_a-z0-9-=\"'\/])((https?|ftp|gopher|news|telnet):\/\/)([^ \r\n\(\)\*\^\$!`\"'\|\[\]\{\}<>]*),i";
				$replace_array[] = "<a href=\"$register_link\" target=\"_blank\">$Guest_message</a>";
				$search_array[] = ",^((https?|ftp|gopher|news|telnet):\/\/|\.)([^ \r\n\(\)\*\^\$!`\"'\|\[\]\{\}<>]*),i";
				$replace_array[] = "<a href=\"$register_link\" target=\"_blank\">$Guest_message</a>";
				$search_array[] = ",([^]_a-z0-9-=\"'\/])((ftp|gopher|news|telnet):\/\/|www\.)([^ \r\n\(\)\*\^\$!`\"'\|\[\]\{\}<>]*),i";
				$replace_array[] = "<a href=\"$register_link\" target=\"_blank\">$Guest_message</a>";
				$search_array[] = "/^([\\._a-zA-Z0-9-]+(\.[\\._a-zA-Z0-9-]+)*@[a-zA-Z0-9-]+(\.[a-zA-Z0-9-]+)*(\.[a-zA-Z]{2,3}))/i";
				$replace_array[] = "<a href=\"$register_link\" target=\"_blank\">$Guest_message</a>";
				//end_replace_links_reply
			    }
            }

 			$string = preg_replace($search_array,$replace_array ,$string);

 		}

 		$string = nl2br($string);

 		return $string;
 	}

 	/**
 	 * The PowerCode should be programmer paradise like Linux ;)
 	 *
 	 * @author : Jason Warner <jason@mercuryboard.com>
 	 *
 	 * @edited by : MaaSTaaR <MaaSTaaR@gmail.com>
 	 *
 	 * @param :
 	 * 	 			code 	-> the code
 	 *				is_php	->	if the code wrote in php this variable should value true to highlight the code
 	 */


 	    function PowerCode_Tag($tag, $message, $att = '')
        {

				if (count(explode('=',$att)) > 2)
                {
                        return $message;
                }

				if (trim($message) == '')
                {
                        return '';
                }

                $message = str_replace('\\"', '"', $message);
                if($tag == 'tag')
                {
                        return $message;
                }

                return "<$tag$att>$message</$tag>";
        }

 	  function PowerCode_Quote($message, $username = '')
        {
        	global $PowerBB;

                if (trim($message) == '')
                {
                        return '';
                }

                $message = str_replace('\\"', '"', $message);

                if($username)
                {
                        return '<div class="quotetop">' .$PowerBB->_CONF['template']['lang']['quote_username'] .' '. $username . ' </div><div class="quotemain">' . $message . '</div>';
                }
                return '<div class="quotetop">'.$PowerBB->_CONF['template']['lang']['quote'].'</div><div class="quotemain">' . $message . '</div>';
        }

 	  function PowerCode_table($txt)
        {
        	global $PowerBB;

                return '<table style="width: 100%; padding: 0px; border: none; border: 1px solid #789DB3; background-color: #F4F4F4;">' . $txt . '</table>';
        }

 	  function PowerCode_tr($txt)
        {
        	global $PowerBB;

                return '<tr>' . $txt . '</tr>';
        }

 	  function PowerCode_td($txt)
        {
        	global $PowerBB;
        	$txt = str_replace('\\', '"', $txt);
                return '<td style="font-size: 20px; border: none;border: 1px solid #789DB3; background-color: #F4F4F4;">&nbsp;' . $txt . '</td>';
        }

 	  function PowerCode_th($txt)
        {
        	global $PowerBB;

                return '<th style="font-size: 20px; border: none;border: 1px solid #789DB3; background-color: #F4F4F4;">&nbsp;' . $txt . '</th>';
        }

	function PowerCode_Code($txt)
	{
		global $PowerBB;
		//-----------------------------------------
		// We don't want to trim indentations on the first line
		//-----------------------------------------
		$txt = preg_replace( "#^(\n+)(.+?)$#s", "\\2", $txt );

		$default = "\[code\]$txt\[/code\]";

		if ( $txt == "" )
		{
			return;
		}

		//-----------------------------------------
		// Ensure that spacing is preserved
		//-----------------------------------------
    		//$txt = str_replace( "&" , "&amp;", $txt );
		$txt = str_replace( "<"         , "[" , $txt );
		$txt = str_replace( ">"         , "]" , $txt );
		$txt = str_replace( "&lt;"      , "&#60;" , $txt );
		$txt = str_replace( "&gt;"      , "&#62;" , $txt );
		$txt = str_replace( "&quot;"    , "&#34;" , $txt );
		$txt = str_replace( ":"         , "&#58;" , $txt );
		$txt = str_replace( "["         , "&#91;" , $txt );
		$txt = str_replace( "]"         , "&#93;" , $txt );
		$txt = str_replace( ")"         , "&#41;" , $txt );
		$txt = str_replace( "("         , "&#40;" , $txt );
		$txt = str_replace( "\r"        , "<br", $txt );
		$txt = str_replace( "\n"        , "/>", $txt );
		$txt = str_replace('\\"'        , '"', $txt);
		$txt = preg_replace( "#\s{1};#" , "&#59;" , $txt );

		//-----------------------------------------
		// Ensure that spacing is preserved
		//-----------------------------------------

		$txt = preg_replace( "#\t{2}#"   , "&nbsp;&nbsp;&nbsp;&nbsp;", $txt );
		$txt = preg_replace( "#\s{2}#", "&nbsp;&nbsp;"            , $txt );

		//$txt = str_replace( "&" , "&amp;", $txt );
		$txt = str_replace( ":"     , "&#58;", $txt );
		$txt = str_replace( "["     , "&#91;", $txt );
		$txt = str_replace( "]"     , "&#93;", $txt );
		$txt = str_replace( ")"     , "&#41;", $txt );
		$txt = str_replace( "("     , "&#40;", $txt );
		$txt = str_replace( "$"	 , "&#36;", $txt );

		$txt = preg_replace( "/^<br>/"  , "", $txt );
		$txt = preg_replace( "#^<br />#", "", $txt );
		$txt = str_replace( "/^\s+/"   , "", $txt );

  		return '<div class="codetop">'.$PowerBB->_CONF['template']['lang']['code_'].'</div><pre class="codemain" dir="ltr" style="margin: 0px;padding: 6px;border: 1px dotted #000;width: 730px; height: 10%;float: left; text-align: left;overflow: auto">' .  $txt . '</pre>';

	}

        function PowerCode_Url($link, $message)
        {
                if (trim($message) == '')
                {
                        return '';
                }

                $message = str_replace('\\"', '"', $message);
                $link = str_replace(array('"', "'"), array('&quot;', '&#39;'), $link);
				if ($PowerBB->_CONF['info_row']['haid_links_for_guest'] == 0)
				{
				return "<a href=\"$link\" target=\"_blank\">$message</a>";
				}
				else
				{
				$Guest_message = ($PowerBB->_CONF['info_row']['guest_message_for_haid_links']);
				$register_link = ('index.php?page=register&index=1');
                if ($PowerBB->_CONF['member_permission'])
				{
				return "<a href=\"$link\" target=\"_blank\">$message</a>";
								}
                if ($PowerBB->_CONF['member_permission'])
				{
				return "<a href=\"$register_link\" target=\"_blank\">$Guest_message</a>";
                }
				}
        }

		function PowerCode_Email($link, $message)
        {
			if (eregi("^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[_a-z0-9-]+(\.[_a-z0-9-]+)", $link))
			{
                return "<a href=\"mailto:$link\" target=\"_blank\">$message</a>";
			}
			else
			{
                return '';
			}
        }

		function PowerCode_Youtube($linky, $messages)
        {
                if (trim($messages) == '')
                {
                        return '';
                }

                $messages = str_replace('\\"', '"', $messages);
                $linky = str_replace(array('"', "'"), array('&quot;', '&#39;'), $linky);
                $linky = str_replace(array('/watch?', "v="), array('/v', '/'), $linky);
                return "<span><object width='425' height='344'><param name='movie' value='$linky'></param><param name='allowFullScreen' value='true'></param><param name='allowscriptaccess' value='always'></param><embed src='$linky' type='application/x-shockwave-flash' allowscriptaccess='always' allowfullscreen='true' width='425' height='344'></embed></object></span>";
         }
		function PowerCode_Media($linky, $messages)
        {
                if (trim($messages) == '')
                {
                        return '';
                }

                $messages = str_replace('\\"', '"', $messages);
                $linky = str_replace(array('"', "'"), array('&quot;', '&#39;'), $linky);
                return "<span><object width='350' height='350'><param name='movie' value='$linky'><PARAM name='ShowControls' VALUE='true'><param name='ShowStatusBar' value='true'><PARAM name='ShowDisplay' VALUE='false'><PARAM name='autostart' VALUE='false'><embed src='$linky' type='application/x-mplayer2' ShowControls='1' ShowStatusBar='1' ShowDisplay='0' autostart='0' width='350' height='300'></embed></object></span>";
         }

		function PowerCode_Ram($linky, $messages)
        {
                if (trim($messages) == '')
                {
                        return '';
                }

                $messages = str_replace('\\"', '"', $messages);
                $linky = str_replace(array('"', "'"), array('&quot;', '&#39;'), $linky);
                return "<span><object width='275' height='40'><param name='movie' value='$linky'></param><param name='autostart' value='true'></param><param name='allowscriptaccess' value='always'></param><embed src='$linky' type='audio/x-pn-realaudio-plugin' allowscriptaccess='always' allowfullscreen='true' width='275' height='40'></embed></object></span>";

         }


        function PowerCode_Flash ($message, $param1 = '', $param2 = '', $type = '' )
		{
			if (trim($message) == '' || $type == '')
			{
			return '';
		    }

			if (!preg_match('#^[a-z]+://#si', $message)){
			return '';
			}
			$param1 = intval($param1);
			$param2 = intval($param2);
            $html = '<span><embed src="'.$message.'" width="'.$param2.'" height="'.$param1.'" quality=high wmode=transparent loop=true menu=false TYPE="application/x-shockwave-flash"</embed></span>';

			return $html;
	    }


        function DoList($mark,$item)
         {

                  if ($mark=="1")
                  {
                      $tag = "ol";
                  }
                  else
                  {
                      $tag = "ul";
                  }

                  $return = "<".$tag.">";

                  $new_item = explode("[*]" , $item);
                  $new_item = str_replace('\\"', '"', $new_item);
                  for ($i=1; $i <= count($new_item); $i++)
                  {
                       if ($new_item[$i]!="")
                       {
                           $return .= "<li>".$new_item[$i]."</li>";
                       }
                  }

                  $return .= "</".$tag.">";
                  return $return;
         }


 	function censor_words($text)
	{
		global $PowerBB;
       // feltr words
        $text = str_replace('&amp;','&',$text);
        $text = str_replace('{39}',"'",$text);
        //$text = str_replace("\'","'",$text);
        $censorwords = preg_split('#[ \r\n\t]+#', $PowerBB->_CONF['info_row']['censorwords'], -1, PREG_SPLIT_NO_EMPTY);
        $text = str_ireplace($censorwords,'**', $text);
       // $text = str_replace('SCRIPT','S-CRIPT',$text);
        return $text;
	}

 	function replace_smiles(&$text)
	{
		global $PowerBB;

		$smiles = $PowerBB->icon->GetCachedSmiles();

		foreach ($smiles as $smile)
		{
			$PowerBB->functions->CleanVariable($smile,'html');

			$text = str_replace($smile['smile_short'],'<img src="' . $smile['smile_path'] . '" border="0" alt="' . $smile['smile_short'] . '" />',$text);
		}
	}


 	function replace_smiles_print(&$text)
	{
		global $PowerBB;

		$smiles = $PowerBB->icon->GetCachedSmiles();

		foreach ($smiles as $smile)
		{
            $Adress = $PowerBB->functions->GetForumAdress();
			$text = str_replace($smile['smile_short'],'<img src="' . $Adress.$smile['smile_path'] . '" border="0" />',$text);
		}
	}


	function replace_wordwrap(&$text)
	{
		global $PowerBB;
       $wordwrap = $PowerBB->_CONF['info_row']['wordwrap'];
	   $text = @wordwrap($text, $wordwrap, "\n", true);

	}


 	function word_substr(&$text)
	{
		global $PowerBB;

       $num ='40';
       $start ='0';
       $text = preg_replace('#^(?:[\x00-\x7F]|[\xC0-\xFF][\x80-\xBF]+){0,'. $start .'}'.'((?:[\x00-\x7F]|[\xC0-\xFF][\x80-\xBF]+){0,'. $num .'}).*#s','$1', $text);
	}

 	function long_word_substr(&$text)
	{
		global $PowerBB;

       $num ='300';
       $start ='0';
       $text = preg_replace('#^(?:[\x00-\x7F]|[\xC0-\xFF][\x80-\xBF]+){0,'. $start .'}'.'((?:[\x00-\x7F]|[\xC0-\xFF][\x80-\xBF]+){0,'. $num .'}).*#s','$1', $text);
	}

 	function short_word_substr(&$text)
	{
		global $PowerBB;
       $num ='20';
       $start ='0';
       $text = preg_replace('#^(?:[\x00-\x7F]|[\xC0-\xFF][\x80-\xBF]+){0,'. $start .'}'.'((?:[\x00-\x7F]|[\xC0-\xFF][\x80-\xBF]+){0,'. $num .'}).*#s','$1', $text);
	}

       function PowerCode_Tag_Url($link, $message)
        {
        	global $PowerBB;
          $Guest_message = ($PowerBB->_CONF['info_row']['guest_message_for_haid_links']);
          $register_link = ('index.php?page=register&index=1');

                if (trim($message) == '')
                {
                        return '';
                }

                $message = str_replace('\\"', '"', $message);
                $link = str_replace(array('"', "'"), array('&quot;', '&#39;'), $link);

				if ($PowerBB->_CONF['info_row']['haid_links_for_guest'] == 0)
				{
				 return "<a href=\"$link\" target=\"_blank\">$message</a>";
				}
				else
				{

	                 if ($PowerBB->_CONF['member_permission'])
					 {
						return "<a href=\"$link\" target=\"_blank\">$message</a>";
					 }
	                if (!$PowerBB->_CONF['member_permission'])
					{
					return "<a href=\"$register_link\" target=\"_blank\">$Guest_message</a>";
	                }
				}
        }

	function strip_smiles(&$text)
	{
   		global $PowerBB;

		$smiles = $PowerBB->icon->GetCachedSmiles();

		foreach ($smiles as $smile)
		{
			$PowerBB->functions->CleanVariable($smile,'html');

			$text = str_replace('<img src="' . $smile['smile_path'] . '" border="0" alt="' . $smile['smile_short'] . '" />',$smile['smile_short'],$text);
		}
    }

 // Resize Image proportionally and return the resized image url

    function resize_image($img)
    {
        global $PowerBB;

        if ($PowerBB->_CONF['info_row']['resize_imagesAllow'] != 1)
        {
                return '<img border="0" src="' . $img . '">';
        }

        $image = @GetImageSize( $img );
        $default_width  = $PowerBB->_CONF['info_row']['default_imagesW'];
        $default_height = $PowerBB->_CONF['info_row']['default_imagesH'];

       $width  = ($image[0] > $default_width) ? $default_width : $image[0];
       $height = ($image[1] > $default_height) ? $default_height : $image[1];

        if ($image[0] > $default_width || $image[1] > $default_height)
        {
           return '<img border="0" src="' . $img . '" width="' . $width . '" height="' . $height . '" alt="" onload="resize_image(this, \'' .  $img . '\', 800);" /><br><a target="_blank" href="' . $img . '"><span style=" width:' . $width . 'px;" class="resizebar">   &nbsp;&nbsp;&nbsp;&nbsp;    '.$PowerBB->_CONF['template']['lang']['resize_image_w_h'].'</span></a>';
        }
        else
        {
          return '<img src="' .  $img . '" border="0" alt="" onload="resize_image(this, \'' .  $img . '\', 800);" />';
        }
     }



   //end_function

 }

?>
