<?php

(!defined('IN_PowerBB')) ? die() : '';

include('common.php');

define('CLASS_NAME','PowerBBAdsPageMOD');

class PowerBBAdsPageMOD
{
	function run()
	{
		global $PowerBB;

		/** Go to ads site **/
		if ($PowerBB->_GET['goto'])
		{
			$this->_GoToSite();
		}
		/** **/
		else
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

		$PowerBB->functions->GetFooter();
	}

	/**
	 * Get the information of ads , then go to the site of ads
	 */
	function _GoToSite()
	{
		global $PowerBB;

		// Show header, The parameter is the page title.
		$PowerBB->functions->ShowHeader($PowerBB->_CONF['template']['lang']['Go_to_site']);

		// Clean _GET['id'] from strings and protect ourself
		$PowerBB->_GET['id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['id'],'intval');

		// Show the address bar, It's make the browse easy
		$PowerBB->functions->AddressBar($PowerBB->_CONF['template']['lang']['Go_ads']);

		// No id ! stop the page :)
		if (empty($PowerBB->_GET['id']))
		{
          $PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Sorry_url_not_true']);
		}

		// Get Ads information
		$AdsArr 			= 	array();
		$AdsArr['where'] 	= 	array('id',$PowerBB->_GET['id']);

		$AdsRows = $PowerBB->ads->GetAdsInfo($AdsArr);

		// Clean the ads information from XSS dirty
		$PowerBB->functions->CleanVariable($AdsRows,'html');

		// Ads isn't here !
		if (!$AdsRows)
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['The_ads_does_not_exist']);
		}

		// New visitor
		$NewClickArr 			= 	array();
		$NewClickArr['clicks'] 	= 	$AdsRows['clicks'];
		$NewClickArr['where'] 	= 	array('id',$AdsRows['id']);

		$PowerBB->ads->NewVisit($NewClickArr);

		// Go to the site
		$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Please_wait_will_be_taken_to_the_following_location'] . $AdsRows['sitename']);
		$PowerBB->functions->redirect($AdsRows['site']);
	}
}

?>
