<?php

// ##############################################################################||
// #
// #   PowerBB Version 2.0.0
// #   http://www.PBBoard.com
// #   Copyright (c) 2009 by Abu.Rakan
// #
// #   filename : forum_archive.module.php
// #
// ##############################################################################||

(!defined('IN_PowerBB')) ? die() : '';

$CALL_SYSTEM					=	array();
$CALL_SYSTEM['SECTION'] 		= 	true;
$CALL_SYSTEM['SUBJECT'] 		= 	true;

include('common.php');

define('CLASS_NAME','PowerBBForumArchiveMOD');

class PowerBBForumArchiveMOD
{
	var $Section;
	var $SectionGroup;

	function run()
	{
		global $PowerBB;

		$PowerBB->template->assign('SECTION_ID',$PowerBB->_GET['id']);

		/** Browse the forum **/
		if ($PowerBB->_GET['show'])
		{
			$this->_BrowseForum();
		}
		/** **/
		elseif ($PowerBB->_GET['password_check'])
		{
			$this->_PasswordCheck();
		}
		else
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

	}

	/**
	 * Get all things about section , subjects of the sections , announcement and sub sections to show it
	 * Yes it's long list :\
	 */
	function _BrowseForum()
	{
		global $PowerBB;

		$this->_GeneralProcesses();

		$this->_GetSubSection();

		$this->_GetSubjectList();

		$this->_CallTemplate();
	}

	function _PasswordCheck()
	{
		global $PowerBB;

		if (empty($PowerBB->_POST['password']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['PasswordCheck']);
		}

		$this->_GeneralProcesses(true);

		$PassArr 				= 	array();
     	$PassArr['id'] 			= 	$this->Section['id'];
     	$PassArr['password'] 	= 	$PowerBB->_POST['password'];

     	$IsTruePassword = $PowerBB->section->CheckPassword($PassArr);

     	if (!$IsTruePassword)
     	{
     		$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['PasswordIsnotTrue']);
     	}
     	else
     	{
     		$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Please_wait']);
     		$PowerBB->functions->redirect('index.php?page=forum_archive&amp;show=1&amp;id=' . $this->Section['id'] . '&amp;password=' . base64_encode($PowerBB->_POST['password']));
     	}
	}

	function _GeneralProcesses($check=false)
	{
		global $PowerBB;

		// Clean id from any strings
		$PowerBB->_GET['id'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['id'],'intval');

		// No _GET['id'] , so ? show a small error :)
		if (empty($PowerBB->_GET['id']))
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['path_not_true']);
		}

		// Get section information and set it in $this->Section
		$SecArr 			= 	array();
		$SecArr['where'] 	= 	array('id',$PowerBB->_GET['id']);

		$this->Section = $PowerBB->section->GetSectionInfo($SecArr);

		// Clear section information from any denger
		$PowerBB->functions->CleanVariable($this->Section,'html');

		$PowerBB->template->assign('section_info',$this->Section);

		// Temporary array to save the parameter of GetSectionGroupList() in nice way
		$SecGroupArr 						= 	array();
		$SecGroupArr['where'] 				= 	array();

		$SecGroupArr['where'][0]			=	array(	'name' 	=> 'section_id',
														'oper'	=>	'=',
														'value'	=>	$this->Section['id']);

		$SecGroupArr['where'][1]			=	array();
		$SecGroupArr['where'][1]['con']		=	'AND';
		$SecGroupArr['where'][1]['name']	=	'group_id';
		$SecGroupArr['where'][1]['oper']	=	'=';
		$SecGroupArr['where'][1]['value']	=	$PowerBB->_CONF['group_info']['id'];


		// Ok :) , the permssion for this visitor/member in this section
		$this->SectionGroup = $PowerBB->group->GetSectionGroupInfo($SecGroupArr);

		// This section isn't exists
		if (!$this->Section)
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['Section_does_not_exist']);
		}

		// This member can't view this section
		if ($this->SectionGroup['view_section'] != 1)
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['can_not_view_section']);
		}

		// This is main section , so we can't get subjects list from it
		if ($this->Section['main_section'])
		{
			$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['thes_main_section']);
		}

		// This section is link , so we should go to another site
		if ($this->Section['linksection'])
		{
			$PowerBB->functions->msg($PowerBB->_CONF['template']['lang']['Please_wait_will_be_referred_to'] . $this->Section['linksite']);
			$PowerBB->functions->redirect($this->Section['linksite'],3);
			$PowerBB->functions->stop();
		}

		// hmmmm , this section protect by password so request the password
		if (!$check)
		{
			if (!empty($this->Section['section_password'])
				and !$PowerBB->_CONF['group_info']['admincp_allow'])
			{
     			if (empty($PowerBB->_GET['password']))
        		{
      				$PowerBB->template->display('forum_password');
      				$PowerBB->functions->stop();
     			}
     			else
     			{
     				$PassArr = array();
     				$PassArr['id'] 			= 	$this->Section['id'];
     				$PassArr['password'] 	= 	base64_decode($PowerBB->_GET['password']);

     				$IsTruePassword = $PowerBB->section->CheckPassword($PassArr);

     				if (!$IsTruePassword)
     				{
     					$PowerBB->functions->error($PowerBB->_CONF['template']['lang']['The_password_notTrue']);
     				}

     				$PowerBB->_CONF['template']['password'] = '&amp;password=' . $PowerBB->_GET['password'];
     			}
     		}
     	}

     	if ($PowerBB->_CONF['member_permission'])
     	{
     		$UpdateOnline 			= 	array();
			$UpdateOnline['field']	=	array();

			$UpdateOnline['field']['user_location']		=	$PowerBB->_CONF['template']['lang']['Seen_the'] . $this->Section['title'];
			$UpdateOnline['where']						=	array('username',$PowerBB->_CONF['member_row']['username']);

			$update = $PowerBB->online->UpdateOnline($UpdateOnline);
     	}
	}



	function _GetSubSection()
	{
		global $PowerBB;

		if (!empty($this->Section['forums_cache']))
		{
			$forums = unserialize(base64_decode($this->Section['forums_cache']));

			$PowerBB->_CONF['template']['foreach']['forums_list'] = array();

			foreach ($forums as $forum)
			{
				if (is_array($forum['groups'][$PowerBB->_CONF['group_info']['id']]))
				{
					if ($forum['groups'][$PowerBB->_CONF['group_info']['id']]['view_section'])
					{
						$PowerBB->_CONF['template']['foreach']['forums_list'][$forum['id'] . '_f'] = $forum;
					}
				} // end if is_array
			} // end foreach ($forums)

			$PowerBB->template->assign('SHOW_SUB_SECTIONS',true);
		}
		else
		{
			$PowerBB->template->assign('SHOW_SUB_SECTIONS',false);
		}
	}

	function _GetSubjectList()
	{
		global $PowerBB;

		/**
		 * Ok , are you ready to get subjects list ? :)
		 */
		$TotalArr 				= 	array();
		$TotalArr['get_from'] 	= 	'db';
		$TotalArr['where'] 		= 	array('section',$this->Section['id']);

		$SubjectArr = array();

		$SubjectArr['where'] 				= 	array();

		$SubjectArr['where'][0] 			= 	array();
		$SubjectArr['where'][0]['name'] 	= 	'section';
		$SubjectArr['where'][0]['oper'] 	= 	'=';
		$SubjectArr['where'][0]['value'] 	= 	$this->Section['id'];

		$SubjectArr['where'][1] 			= 	array();
		$SubjectArr['where'][1]['con']		=	'AND';
		$SubjectArr['where'][1]['name'] 	= 	'stick';
		$SubjectArr['where'][1]['oper'] 	= 	'<>';
		$SubjectArr['where'][1]['value'] 	= 	'1';

		$SubjectArr['where'][2] 			= 	array();
		$SubjectArr['where'][2]['con']		=	'AND';
		$SubjectArr['where'][2]['name'] 	= 	'delete_topic';
		$SubjectArr['where'][2]['oper'] 	= 	'<>';
		$SubjectArr['where'][2]['value'] 	= 	'1';

		$SubjectArr['where'][3] 			= 	array();
		$SubjectArr['where'][3]['con']		=	'AND';
		$SubjectArr['where'][3]['name'] 	= 	'review_subject';
		$SubjectArr['where'][3]['oper'] 	= 	'<>';
		$SubjectArr['where'][3]['value'] 	= 	'1';

		if ($this->Section['hide_subject']
			and !$PowerBB->_CONF['group_info']['admincp_allow'])
		{
			$SubjectArr['where'][2] 			= 	array();
			$SubjectArr['where'][2]['con'] 		= 	'AND';
			$SubjectArr['where'][2]['name'] 	= 	'writer';
			$SubjectArr['where'][2]['oper'] 	= 	'=';
			$SubjectArr['where'][2]['value'] 	= 	$PowerBB->_CONF['member_row']['username'];
		}

		$SubjectArr['order'] = array();

		if ($this->Section['subject_order'] == 2)
		{
			$SubjectArr['order']['field'] 	= 	'id';
			$SubjectArr['order']['type'] 	= 	'DESC';
		}
		elseif ($this->Section['subject_order'] == 3)
		{
			$SubjectArr['order']['field'] 	= 	'id';
			$SubjectArr['order']['type'] 	= 	'ASC';
		}
		else
		{
			$SubjectArr['order']['field'] 	= 	'write_time';
			$SubjectArr['order']['type'] 	= 	'DESC';
		}

		$PowerBB->_GET['count'] = (!isset($PowerBB->_GET['count'])) ? 0 : $PowerBB->_GET['count'];
		$PowerBB->_GET['count'] = $PowerBB->functions->CleanVariable($PowerBB->_GET['count'],'intval');

		$SubjectArr['proc'] 						= 	array();
		// Ok Mr.XSS go to hell !
		$SubjectArr['proc']['*'] 					= 	array('method'=>'clean','param'=>'html');
		$SubjectArr['proc']['native_write_time'] 	= 	array('method'=>'date','store'=>'write_date','type'=>$PowerBB->_CONF['info_row']['timesystem']);
		$SubjectArr['proc']['write_time'] 			= 	array('method'=>'date','store'=>'reply_date','type'=>$PowerBB->_CONF['info_row']['timesystem']);


		$PowerBB->_CONF['template']['while']['subject_list'] = $PowerBB->subject->GetSubjectList($SubjectArr);


		//////////

		$StickSubjectArr = array();

		$StickSubjectArr['where'] 				= 	array();

		$StickSubjectArr['where'][0] 			= 	array();
		$StickSubjectArr['where'][0]['name'] 	= 	'section';
		$StickSubjectArr['where'][0]['oper'] 	= 	'=';
		$StickSubjectArr['where'][0]['value'] 	= 	$this->Section['id'];

		$StickSubjectArr['where'][1] 			= 	array();
		$StickSubjectArr['where'][1]['con']		=	'AND';
		$StickSubjectArr['where'][1]['name'] 	= 	'stick';
		$StickSubjectArr['where'][1]['oper'] 	= 	'=';
		$StickSubjectArr['where'][1]['value'] 	= 	'1';

		$StickSubjectArr['where'][2] 			= 	array();
		$StickSubjectArr['where'][2]['con']		=	'AND';
		$StickSubjectArr['where'][2]['name'] 	= 	'delete_topic';
		$StickSubjectArr['where'][2]['oper'] 	= 	'<>';
		$StickSubjectArr['where'][2]['value'] 	= 	'1';

		$StickSubjectArr['order'] = array();
		$StickSubjectArr['order']['field'] 	= 	'write_time';
		$StickSubjectArr['order']['type'] 	= 	'DESC';

		$StickSubjectArr['proc'] 						= 	array();
		// Ok Mr.XSS go to hell !
		$StickSubjectArr['proc']['*'] 					= 	array('method'=>'clean','param'=>'html');
		$StickSubjectArr['proc']['native_write_time'] 	= 	array('method'=>'date','store'=>'write_date','type'=>$PowerBB->_CONF['info_row']['timesystem']);
		$StickSubjectArr['proc']['write_time'] 			= 	array('method'=>'date','store'=>'reply_date','type'=>$PowerBB->_CONF['info_row']['timesystem']);

		$PowerBB->_CONF['template']['while']['stick_subject_list'] = $PowerBB->subject->GetSubjectList($StickSubjectArr);

		if (sizeof($PowerBB->_CONF['template']['while']['stick_subject_list']) <= 0)
		{
			$PowerBB->template->assign('NO_STICK_SUBJECTS',true);
		}
		else
		{
			$PowerBB->template->assign('NO_STICK_SUBJECTS',false);
		}

		//////////


		$PowerBB->template->assign('section_id',$this->Section['id']);
	}

	function _CallTemplate()
	{
		global $PowerBB;

		$PowerBB->template->display('archive_forum');
		$PowerBB->template->display('archive_footer');
	}
}

?>
