<?php
# legal notes:
# this file is a mimic of the existing /admincp/template.php file originating from vBulletin.
# it was modified to fit the needs of exporting entire styles, feature missing still in 3.8.x.

# 1- export/backup all templates from style X, even the Master can be exported
# 2- import/insert all templates from backup in a new style, no parent.


####################################################################################################
# NOTE: you can not use a backup on a vBulletin that do not have the nex_backup_style product installed or you will break your templates.
####################################################################################################


################################################################################ SET PHP ENVIRONMENT
error_reporting(E_ALL & ~E_NOTICE);
@set_time_limit(0);
ignore_user_abort(true);

####################################################################### PRE-CACHE TEMPLATES AND DATA
$phrasegroups = array('style');
$specialtemplates = array();

################################################################################### REQUIRE BACK-END
require_once('./global.php');
require_once(DIR . '/includes/adminfunctions_template.php');

############################################################################ CHECK ADMIN PERMISSIONS
if (!can_administer('canadminstyles')) print_cp_no_permission();

$vbulletin->input->clean_array_gpc('r', array('dostyleid' => TYPE_INT));

######################################################################################### LOG ACTION
log_admin_action('download style id = ' . $vbulletin->GPC['dostyleid']);

################################################################################## START MAIN SCRIPT
if (empty($_REQUEST['do'])) $_REQUEST['do'] = 'files';
if ($_REQUEST['do'] != 'download')
{
	print_cp_header($vbphrase['style_manager'], iif($_REQUEST['do'] == 'files', 'js_fetch_style_title()'));
	?><script type="text/javascript" src="../clientscript/vbulletin_templatemgr.js"></script><?php
}
################################################################## DOWNLOAD STYLE WITH ALL TEMPLATES
if ($_REQUEST['do'] == 'download')
{

	if (function_exists('set_time_limit') AND !SAFEMODE)
	{
		@set_time_limit(1200);
	}

	$vbulletin->input->clean_array_gpc('r', array(
		'filename' => TYPE_STR,
		'title'    => TYPE_NOHTML,
		'product'  => TYPE_STR
	));

	// --------------------------------------------
	// work out what we are supposed to do

	// set a default filename
	if (empty($vbulletin->GPC['filename'])) $vbulletin->GPC['filename'] = 'backup-style.xml';

	if ($vbulletin->GPC['dostyleid'] == -1)
	{
		// set the style title as 'master style'
		$style = array('title' => $vbphrase['master_style']);

		$sqlcondition = "styleid = -1";
	}
	else
	{
		// query everything from the specified style
		$style = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "style WHERE styleid = " . $vbulletin->GPC['dostyleid']);

		// get all items from this style and all parent styles (except master)
		$sqlcondition = "styleid <> -1 AND templateid IN(" . implode(',', unserialize($style['templatelist'])) . ")";
	}

	// set a default title
	if ($vbulletin->GPC['title'] == '' OR $vbulletin->GPC['dostyleid'] == -1)
	{
		$vbulletin->GPC['title'] = $style['title'];
	}

	// --------------------------------------------
	// query the templates and put them in an array

	$templates = array();

	$gettemplates = $db->query_read("
		SELECT title, templatetype, username, dateline, version, product,
		IF(templatetype = 'template', template_un, template) AS template
		FROM " . TABLE_PREFIX . "template
		WHERE $sqlcondition
		ORDER BY title
	");
	while ($gettemplate = $db->fetch_array($gettemplates))
	{
		switch($gettemplate['templatetype'])
		{
			case 'template': // regular template
				$isgrouped = false;
				foreach(array_keys($only) AS $group)
				{
					if (strpos(strtolower(" $gettemplate[title]"), $group) == 1)
					{
						$templates["$group"][] = $gettemplate;
						$isgrouped = true;
					}
				}
				if (!$isgrouped)
				{
					$templates['zzz'][] = $gettemplate;
				}
			break;

			case 'stylevar': // stylevar
				$templates['StyleVar Special Templates'][] = $gettemplate;
			break;

			case 'css': // css
				$templates['CSS Special Templates'][] = $gettemplate;
			break;

			case 'replacement': // replacement
				$templates['Replacement Var Special Templates'][] = $gettemplate;
			break;
		}
	}
	unset($template);
	$db->free_result($gettemplates);

	if (empty($templates))
	{
		print_stop_message('download_contains_no_customizations');
	}

	ksort($templates);

	$only['zzz'] = 'Ungrouped Templates';

	// --------------------------------------------
	// now output the XML

	require_once(DIR . '/includes/class_xml.php');
	$xml = new vB_XML_Builder($vbulletin);
	$xml->add_group('style', array(
		'name' => $vbulletin->GPC['title'],
		'version' => '1.0.0',
		'product' => 'nex_backup_style',
		'type' =>'backup'
	));

	foreach($templates AS $group => $grouptemplates)
	{
		$xml->add_group('templategroup', array('name' => iif(isset($only["$group"]), $only["$group"], $group)));
		foreach($grouptemplates AS $template)
		{
			$xml->add_tag('template', $template['template'], array(
				'name' => htmlspecialchars($template['title']),
				'templatetype' => $template['templatetype'],
				'date' => $template['dateline'],
				'username' => $template['username'],
				'version' => htmlspecialchars_uni($template['version']),
				'product' => $template['product']
			), true);
		}
		$xml->close_group();
	}

	$xml->close_group();

	$doc = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\r\n\r\n";

	$doc .= $xml->output();
	$xml = null;

	require_once(DIR . '/includes/functions_file.php');
	file_download($doc, $vbulletin->GPC['filename'], 'text/xml');

}


// #############################################################################
// upload style

if ($_POST['do'] == 'upload')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'serverfile'       => TYPE_STR,
		'title'            => TYPE_STR,
		'displayorder'     => TYPE_INT,
		'userselect'       => TYPE_BOOL,
	));

	$vbulletin->input->clean_array_gpc('f', array(
		'stylefile'        => TYPE_FILE,
	));

	// got an uploaded file?
	if (file_exists($vbulletin->GPC['stylefile']['tmp_name']))
	{
		$xml = file_read($vbulletin->GPC['stylefile']['tmp_name']);
	}
	// no uploaded file - got a local file?
	else if (file_exists($vbulletin->GPC['serverfile']))
	{
		$xml = file_read($vbulletin->GPC['serverfile']);
	}
	// no uploaded file and no local file - ERROR
	else
	{
		print_stop_message('no_file_uploaded_and_no_local_file_found');
	}

	nex_xml_import_style($xml, $vbulletin->GPC['title'], $vbulletin->GPC['displayorder'], $vbulletin->GPC['userselect']);

	print_cp_redirect("template.php?" . $vbulletin->session->vars['sessionurl'] . "do=rebuild", 0);

}


########################################################################### SELECT STYLE TO DOWNLOAD
if ($_REQUEST['do'] == 'files')
{

	cache_styles();
	?>
	<script type="text/javascript">
	<!--
	function js_confirm_upload(tform, filefield)
	{
		if (filefield.value == "")
		{
			return confirm("<?php echo construct_phrase($vbphrase['you_did_not_specify_a_file_to_upload'], '" + tform.serverfile.value + "'); ?>");
		}
		return true;
	}
	function js_fetch_style_title()
	{
		styleid = document.forms.downloadform.dostyleid.options[document.forms.downloadform.dostyleid.selectedIndex].value;
		document.forms.downloadform.title.value = style[styleid];
		document.forms.downloadform.filename.value = style[styleid].replace(/ /g,"_") + "-backup.xml";
	}
	var style = new Array();
	style['-1'] = "<?php echo $vbphrase['master_style'] . '";';
	foreach($stylecache AS $styleid => $style)
	{
		echo "\n\tstyle['$styleid'] = \"" . addslashes_js($style['title'], '"') . "\";";
		$styleoptions["$styleid"] = construct_depth_mark($style['depth'], '--', iif($vbulletin->debug, '--', '')) . ' ' . $style['title'];
	}
	echo "\n";
	?>
	// -->
	</script>
	<?php

	print_form_header('nex_backup_style', 'download', 0, 1, 'downloadform" target="download');
	print_table_header($vbphrase['nex_backup_style_download_title']);
	print_label_row($vbphrase['style'], '
		<select name="dostyleid" onchange="js_fetch_style_title();" tabindex="1" class="bginput">
		<option value="-1">' . $vbphrase['master_style'] . '</option>
		' . construct_select_options($styleoptions, $vbulletin->GPC['dostyleid']) . '
		</select>
	', '', 'top', 'dostyleid');
	print_input_row($vbphrase['title'], 'title');
	print_input_row($vbphrase['filename'], 'filename');
	print_submit_row($vbphrase['download']);

	print_form_header('nex_backup_style', 'upload', 1, 1, 'uploadform" onsubmit="return js_confirm_upload(this, this.stylefile);');
	print_table_header($vbphrase['nex_backup_style_import_title']);
	print_upload_row($vbphrase['upload_xml_file'], 'stylefile', 999999999);
	print_input_row($vbphrase['import_xml_file'], 'serverfile', './install/style-backup.xml');
	print_description_row($vbphrase['nex_backup_style_desc_of_upload'], 0, 2, 'thead" style="font-weight:normal; text-align:center');
	print_input_row($vbphrase['title_for_uploaded_style'], 'title');
	print_input_row($vbphrase['display_order'], 'displayorder', 1);
	print_yes_no_row($vbphrase['allow_user_selection'], 'userselect', 1);

	print_submit_row($vbphrase['import']);

	print_cp_footer();
}






/// #############################################################################
/**
* Reads XML style file and imports data from it into the database
*
* @param	string	XML data
* @param	integer	Style ID
* @param	integer	Parent style ID
* @param	string	New style title
* @param	boolean	Allow vBulletin version mismatch
* @param	integer	Display order for new style
* @param	boolean	Allow user selection of new style
*/
function nex_xml_import_style($xml = false, $title = '', $displayorder = 1, $userselect = true)
{

	// $GLOBALS['path'] needs to be passed into this function or reference $vbulletin->GPC['path']

	global $vbulletin, $vbphrase;

	print_dots_start('<b>' . $vbphrase['importing_style'] . "</b>, $vbphrase[please_wait]", ':', 'dspan');

	require_once(DIR . '/includes/class_xml.php');

	$xmlobj = new vB_XML_Parser($xml, $vbulletin->GPC['path']);
	if ($xmlobj->error_no == 1)
	{
			print_dots_stop();
			print_stop_message('no_xml_and_no_path');
	}
	else if ($xmlobj->error_no == 2)
	{
			print_dots_stop();
			print_stop_message('please_ensure_x_file_is_located_at_y', 'vbulletin-style.xml', $vbulletin->GPC['path']);
	}

	if(!$arr = $xmlobj->parse())
	{
		print_dots_stop();
		print_stop_message('xml_error_x_at_line_y', $xmlobj->error_string(), $xmlobj->error_line());
	}

	if (!$arr['templategroup'])
	{
		print_dots_stop();
		print_stop_message('invalid_file_specified');
	}

	$title = (empty($title) ? $arr['name'] : $title);

	$arr = $arr['templategroup'];
	if (empty($arr[0]))
	{
		$arr = array($arr);
	}

	// creating a new style
	if ($test = $vbulletin->db->query_first("
		SELECT styleid FROM " . TABLE_PREFIX . "style
		WHERE title = '" . $vbulletin->db->escape_string($title) . "'
	"))
	{
		$title = $title . ' - IMPORT';
	}
	echo "<h3><b>" . construct_phrase($vbphrase['creating_a_new_style_called_x'], $title) . "</b></h3>\n<p>$vbphrase[please_wait]</p>";
	vbflush();
	/*insert query*/
	$styleresult = $vbulletin->db->query_write("
		INSERT INTO " . TABLE_PREFIX . "style
		(title, parentid, displayorder, userselect)
		VALUES
		('" . $vbulletin->db->escape_string($title) . "', -1, $displayorder, " . ($userselect ? 1 : 0) . ")
	");
	$styleid = $vbulletin->db->insert_id($styleresult);

	// types array...
	$types = array($vbphrase['template'], $vbphrase['stylevar'], $vbphrase['css'], $vbphrase['replacement_variable']);

	$querybits = array();
	$querytemplates = 0;


	foreach ($arr AS $templategroup)
	{
		if (empty($templategroup['template'][0]))
		{
			$tg = array($templategroup['template']);
		}
		else
		{
			$tg =& $templategroup['template'];
		}

		foreach($tg AS $template)
		{
			$template['name'] = $vbulletin->db->escape_string($template['name']);
			$template['template'] = $vbulletin->db->escape_string($template['value']);
			$template['username'] = $vbulletin->db->escape_string($template['username']);
			$template['product'] = $vbulletin->db->escape_string($template['product']);
			$template['version'] = $vbulletin->db->escape_string($template['version']);

			if ($template['templatetype'] != 'template')
			{
				// template is a special template
				$querybits[] = "($styleid, '$template[templatetype]', '$template[name]', '$template[template]', '', $template[date], '$template[username]', '$template[version]', '$template[product]')";
			}
			else
			{
				// template is a standard template
				$querybits[] = "($styleid, '$template[templatetype]', '$template[name]', '" . $vbulletin->db->escape_string(compile_template($template['value'])) . "', '$template[template]', $template[date], '$template[username]', '$template[version]', '$template[product]')";
			}


			if (++$querytemplates % 20 == 0)
			{
				/*insert query*/
				$vbulletin->db->query_write("
					REPLACE INTO " . TABLE_PREFIX . "template
					(styleid, templatetype, title, template, template_un, dateline, username, version, product)
					VALUES
					" . implode(',', $querybits) . "
				");
				$querybits = array();
			}
		}
	}

	// insert any remaining templates
	if (!empty($querybits))
	{
		/*insert query*/
		$vbulletin->db->query_write("
			REPLACE INTO " . TABLE_PREFIX . "template
			(styleid, templatetype, title, template, template_un, dateline, username, version, product)
			VALUES
			" . implode(',', $querybits) . "
		");
	}
	unset($querybits);

	print_dots_stop();

}

?>