<?php
if ($block == 'mostviewedthread' AND $vbulletin->options['dbtech_infopanel_mostviewedthread_enabled'])
{
	// Add New Posts
	$xml->add_tag('header' . $blockid, $vbphrase['dbtech_infopanel_most_viewed_threads']);
	
	if (!is_array($mostviewedthreads))
	{
		$mostviewedthreads = fetch_vbo_cache($vbulletin->userinfo['userid'] . '_topthreads');
		if ($mostviewedthreads === false)
		{
			$mostviewedthreads = array();
			$mostviewedthreads_q = $db->query_read_slave("
				SELECT thread.threadid, thread.title, thread.lastpost, thread.lastpostid, thread.forumid, thread.replycount, thread.lastposter, thread.dateline, thread.views, thread.visible, thread.open, user.username, user.userid, user.usergroupid, user.displaygroupid, user.customtitle
				" . (($vbulletin->options['threadmarking'] AND $vbulletin->userinfo['userid']) ? ", threadread.readtime AS threadread" : "") . "
				FROM " . TABLE_PREFIX . "thread AS thread
				LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.username = thread.lastposter)
				" . (($vbulletin->options['threadmarking'] AND $vbulletin->userinfo['userid']) ? " LEFT JOIN " . TABLE_PREFIX . "threadread AS threadread ON (threadread.threadid = thread.threadid AND threadread.userid = " . $vbulletin->userinfo['userid'] . ")" : "") . "
				WHERE NOT ISNULL(thread.threadid)
					AND thread.visible = '1'
					AND thread.open != '10'
					AND thread.forumid IN(0" . implode(', ', $forumids) . ")
					AND thread.views > 0
					$excludegroups
				ORDER BY thread.views DESC
				LIMIT " . $vbulletin->options['dbtech_infopanel_limit']
			);
			while ($mostviewedthreads_r = $db->fetch_array($mostviewedthreads_q))
			{
				if ($vbulletin->options['threadmarking'] AND $vbulletin->userinfo['userid'])
				{
					$forumread = $vbulletin->forumcache["$mostviewedthreads_r[forumid]"]['forumread'];
					$lastread = max($forumread, TIMENOW - ($vbulletin->options['markinglimit'] * 86400));
				}
				else
				{
					$bbforumview = intval(fetch_bbarray_cookie('forum_view', $mostviewedthreads_r['forumid']));
					$lastread = max($bbforumview, $vbulletin->userinfo['lastvisit']);
				}
				
				// Default to old post
				$word = 'old';			
				if ($mostviewedthreads_r['lastpost'] > $lastread)
				{
					if ($vbulletin->options['threadmarking'] AND $mostviewedthreads_r['threadread'])
					{
						$threadview = $mostviewedthreads_r['threadread'];
					}
					else
					{
						$threadview = intval(fetch_bbarray_cookie('thread_lastview', $mostviewedthreads_r['threadid']));
					}
					
					if (!$threadview)
					{
						$threadview = $vbulletin->userinfo['lastvisit'];
					}
		
					if ($mostviewedthreads_r['lastpost'] > $threadview)
					{
						// Yep, this IS a new post
						$word = 'new';
					}
				}			
				
				// Strip tags from username
				$mostviewedthreads_r['fullusername'] = $mostviewedthreads_r['username'] = strip_tags($mostviewedthreads_r['username']);
				
				if ($vbulletin->options['dbtech_infopanel_trimusername'])
				{
					// Trim the username
					$mostviewedthreads_r['username'] = fetch_trimmed_title($mostviewedthreads_r['username'], $vbulletin->options['dbtech_infopanel_trimusername']);
				}
				
				// Fetch coloured username
				$mostviewedthreads_r['musername'] = fetch_musername($mostviewedthreads_r);
				
				// Restore username for SEO Link purposes
				$mostviewedthreads_r['username'] = $mostviewedthreads_r['fullusername'];

				// Strip tags from thread title
				$mostviewedthreads_r['fulltitle'] = $mostviewedthreads_r['title'] = strip_tags($mostviewedthreads_r['title']);
				
				if ($vbulletin->options['dbtech_infopanel_trimthread'])
				{
					// Trim the thread title
					$mostviewedthreads_r['title'] = fetch_trimmed_title($mostviewedthreads_r['title'], $vbulletin->options['dbtech_infopanel_trimthread']);
				}					
				
				// Number formatting
				$mostviewedthreads_r['views'] 		= vb_number_format($mostviewedthreads_r['views']);
				
				// Pre-title shiet
				$mostviewedthreads_r['word'] 		= $word;
				$mostviewedthreads_r['pretitle'] 	= $vbphrase["$word"];
				
				// Store this
				$mostviewedthreads[] = $mostviewedthreads_r;
			}
			$db->free_result($mostviewedthreads_q);
			unset($mostviewedthreads_r);
			
			// Set the cache
			set_vbo_cache($vbulletin->userinfo['userid'] . '_topthreads', $mostviewedthreads, (TIMENOW + ($vbulletin->options['dbtech_infopanels_counter_ttl'] * 60)));
		}
	}
	
	$bit = '';
	foreach ($mostviewedthreads as $post)
	{
		$templater = vB_Template::create('dbtech_infopanel_block_mostviewedthread_bit');
			$templater->register('post', $post);
		$bit .= $templater->render();
	}
	
	// Create the template
	$templater = vB_Template::create('dbtech_infopanel_block_mostviewedthread');
		$templater->register('bit', $bit);
	
	// Add New Posts
	$xml->add_tag('block' . $blockid, $templater->render());
}
?>