// Setup the main object
InfoPanels_Obj = function()
{
	// Which blocks correspond to which thingy
	this.final_countdown 	= false;
	
	// #########################################################################
	// Initialise the Info Panels
	this.init = function()
	{
		if (!AJAX_Compatible)
		{
			// AJAX won't work, this is foar srs.
			YAHOO.util.Dom.get('dbtech_infopanels_status').innerHTML = 'Either your browser does not support AJAX, or the forum administrator has chosen to disable AJAX. InfoPanels cannot run under these conditions.';
			// REPLACESTRING
			
			return false;
		}	
		
		// Fetch the data
		this.fetch();
	}
	
	// #########################################################################
	// Checks whether we need to refresh the data
	this.check_status = function(doreset)
	{
		if (doreset)
		{
			// We're resetting the timer
			this.timeout = this.refreshtime;
		}
		else
		{
			// Withdraw one second
			this.timeout = this.timeout - 1;
		}
		
		if (this.timeout == 0)
		{
			// Timeout reached 0, refresh naow
			this.fetch();
		}
		else
		{
			if (this.final_countdown)
			{
				// Get rid of it if we have it
				clearTimeout(this.final_countdown);
			}
			
			this.final_countdown = setTimeout("InfoPanels.check_status(false)", 1000);
			YAHOO.util.Dom.get('dbtech_infopanels_status').innerHTML = '   ' + this.timeout + ' .';
		}
	}
	
	// #########################################################################
	// Parses the XML feedback	
	this.set_block = function(columnid, column)
	{
		// Set the new block
		this.blocks[columnid] = column;
		
		// Grab the new data
		this.fetch();
	}
	
	// #########################################################################
	// Parses the XML feedback
	this.parse_xml = function(columnid, column, header)
	{
		// Shorthand for this function
		YAHOO.util.Dom.get('dbtech_topxstats_column' + columnid).innerHTML = column[0].firstChild.nodeValue;
		YAHOO.util.Dom.get('dbtech_topxstats_header' + columnid).innerHTML = header[0].firstChild.nodeValue;
	}
	
	// #########################################################################
	// Fetches a given type of content
	this.fetch = function()
	{
		if (!YAHOO.util.Connect.isCallInProgress(this.ajax))
		{
			YAHOO.util.Dom.get('dbtech_infopanels_status').innerHTML = 'Fetching data...';
			
			fetch = new Array();
			for (var i in this.blocks)
			{
				// Store this
				fetch[i] = 'block[' + i + ']=' + this.blocks[i];
			}
			
			// Execute AJAX
			this.ajax = YAHOO.util.Connect.asyncRequest('POST', 'ajax.php?do=dbtech_infopanel_stats', {
				success: this.ajax_completed,
				failure: this.handle_ajax_error,
				timeout: vB_Default_Timeout,
				scope: this
			}, SESSIONURL + 'securitytoken=' + SECURITYTOKEN + '&do=dbtech_infopanel_stats' + fetch.join('&'));
		}
	}
	
	// #########################################################################
	// Finalise fetching of content
	this.ajax_completed = function(ajax)
	{
		if (!ajax.responseXML)
		{
			// Empty response
			YAHOO.util.Dom.get('dbtech_infopanels_status').innerHTML = 'Invalid response from server: ' + ajax.responseText;
			return false;
		}
		
		// check for error first
		var error = ajax.responseXML.getElementsByTagName('error');
			
		if (error.length)
		{
			// Throw the error returned
			YAHOO.util.Dom.get('dbtech_infopanels_status').innerHTML = error[0].firstChild.nodeValue;
			return false;
		}
		
		if (this.refreshtime > 0)
		{
			if (this.final_countdown)
			{
				// Get rid of it if we have it
				clearTimeout(this.final_countdown);
			}
			
			// Auto-refresh status
			this.final_countdown = setTimeout("InfoPanels.check_status(true)", 1000);
		}
		else
		{
			YAHOO.util.Dom.get('dbtech_infopanels_status').innerHTML = ' ""  .';
		}
		
		var block1 = ajax.responseXML.getElementsByTagName('block1');
		var header1 = ajax.responseXML.getElementsByTagName('header1');
		
		var block2 = ajax.responseXML.getElementsByTagName('block2');
		var header2 = ajax.responseXML.getElementsByTagName('header2');
		
		var block3 = ajax.responseXML.getElementsByTagName('block3');
		var header3 = ajax.responseXML.getElementsByTagName('header3');
		
		if (block1.length)
		{
			// Parse block 1
			this.parse_xml(1, block1, header1);
		}
		
		if (block2.length)
		{
			// Parse block 2
			this.parse_xml(2, block2, header2);
		}
		
		if (block3.length)
		{
			// Parse block 3
			this.parse_xml(3, block3, header3);
		}
	}
	
	// #########################################################################
	// This should never happen.
	this.handle_ajax_error = function(ajax)
	{
		if (ajax.statusText == 'transaction aborted' || ajax.statusText == 'communication failure')
		{
			// Try again!
			this.fetch();
			return false;
		}
		
		if (YAHOO.util.Dom.get('dbtech_infopanels_status'))
		{
			YAHOO.util.Dom.get('dbtech_infopanels_status').innerHTML = ajax.statusText;
			
			// Log the error to the console
			console.error(this.timestamp() + "AJAX Error: Status = %s: %s", ajax.status, ajax.statusText);
		}
		else
		{
			// Just pop it up
			alert(ajax.statusText);
		}
	}
}