<?php
function verify_vbo_environment() 
{
	global $vbulletin;
	return ($vbulletin->options['vbo_online'] AND $vbulletin->options['dbtech_infopanels_vbo'] AND vb_optimise::$cache !== NULL);
}
function fetch_vbo_cache($key, $ttl = TIMENOW)
{
	global $vbulletin;
	
	$key = 'dbt_ip_' . $key;
	if (!verify_vbo_environment())
	{
		// vBO isn't being used or some shiet
		return false;
	}
	
	$cache = vb_optimise::$cache->get($key);
	if ($cache === false)
	{
		// Also gtfo
		vb_optimise::report("$key was not cached.");		
		return false;
	}
	
	if ($cache['ttl'] AND $cache['ttl'] < $ttl)
	{
		// Also gtfo
		vb_optimise::report("$key has expired from the cache. TTL: $cache[ttl] - Time Now: " . TIMENOW);		
		return false;
	}
	
	// We has a data
	vb_optimise::report("Fetched $key from cache successfully.");
	vb_optimise::stat(1); // Increments stats by 1 query saved
	
	return ($cache['data']);
}
function set_vbo_cache($key, $data, $ttl = 0)
{
	$key = 'dbt_ip_' . $key;
	if (!verify_vbo_environment())
	{
		// Gtfo
		return;
	}
	
	if (!$ttl OR $ttl == TIMENOW)
	{
		// Always refresh
		return;
	}
	
	$data = array(
		'data' 	=> $data,
		'ttl'	=> $ttl
	);
	
	vb_optimise::report("Setting $key with TTL: $data[ttl] - Time Now: " . TIMENOW);		
	
	// Now cache
	vb_optimise::$cache->set($key, ($data));
}
function build_infopanels_averages()
{
	global $vbulletin;
	
	if (!$vbulletin->products['dbtech_vbactivity'] AND !$vbulletin->products['dbtech_vbshout'])
	{
		// We don't even have what we need
		return false;
	}
	
	$vba = $vbs = array();
	if ($vbulletin->products['dbtech_vbactivity'])
	{
		$vba = $vbulletin->db->query_first_slave("
			SELECT
				ROUND(AVG(dbtech_vbactivity_points), 2) AS avgpoints,
				ROUND(AVG(dbtech_vbactivity_pointscache_day), 2) AS avgpoints_day,
				ROUND(AVG(dbtech_vbactivity_pointscache_week), 2) AS avgpoints_week,
				ROUND(AVG(dbtech_vbactivity_pointscache_month), 2) AS avgpoints_month			
			FROM " . TABLE_PREFIX . "user
			WHERE dbtech_vbactivity_points > 0
				AND dbtech_vbactivity_pointscache_day > 0
				AND dbtech_vbactivity_pointscache_week > 0
				AND dbtech_vbactivity_pointscache_month > 0
		");
	}
	
	if ($vbulletin->products['dbtech_vbshout'])
	{
		$vbs = $vbulletin->db->query_first_slave("
			SELECT
				ROUND(AVG(dbtech_vbshout_shouts), 2) AS avgshouts
			FROM " . TABLE_PREFIX . "user
			WHERE dbtech_vbshout_shouts > 0
		");
	}
	
	// Merge the two
	$vbulletin->dbtech_infopanels_forumstats_avg = $vba + $vbs;
	build_datastore('dbtech_infopanels_forumstats_avg', serialize($vbulletin->dbtech_infopanels_forumstats_avg), 1);
}
?>