<?php
/**
 * Language file to handle email templates
 *
 * This file has the email messages necessary for mail sending for various
 * pages. The admin can change the email template values from the admin interface.
 *
 * PHP version 5.0
 *
 * @category	###Framework###
 * @package		###Common/Email_templates###
 * @author 		selvaraj_47ag04
 * @copyright 	Copyright (c) 2008 {@link http://www.agriya.com Agriya Infoway}
 * @license		http://www.agriya.com Agriya Infoway Licence
 * @version		SVN: $Id: email_notify.inc.php 138 2008-03-31 07:43:22Z selvaraj_47ag04 $
 * @since 		2008-04-02
 */
/**
 * @var string Registration Activation Code Subject
 * @cfg_sec_name General Email Templates
 * @cfg_label Registration Activation Code Subject -- {site_name}
 * @cfg_key activation_subject
 */
$LANG['activation_subject'] = 'Your activation code';
/**
 * @var string Registration Activation Code Content
 * @cfg_label Registration Activation Code Content -- {user_name}{activation_link}{link}{site_name}
 * @cfg_key activation_message
 */
$LANG['activation_message'] = 'Dear {user_name},

Your account is almost ready.

Please click the link below to confirm your email address and activate your account.
{activation_link}

To learn more, please visit {link}

Regards,
{site_name}';
/**
 * @var string welcome email subject
 * @cfg_label welcome email subject {user_name}
 * @cfg_key welcome_email_subject
 */
$LANG['welcome_email_subject'] = 'Welcome {site_name}';
/**
 * @var string welcome email content
 * @cfg_label welcome email content
 * @cfg_key welcome_email_content
 */
$LANG['welcome_email_content'] = 'Dear {user_name},

welcome to the {site_name}

visit url: {site_url}

by
{site_name}';
/**
 * @#var string This is used in groupInvite.php. This is used while sending invitation to join group for internal messages
 * @#cfg_label Sending invitation to join group for internal messages subject -- {group_name}
 * @#cfg_key mail_group_invite_member_subject
 */
$LANG['mail_group_invite_member_subject'] = 'Invitation to Join group {group_name}';
/**
 * @#var string This is used in groupInvite.php. This is used while sending invitation to join group for internal messages
 * @#cfg_label Sending invitation to join group for internal messages content -- {friend_name}{user_name}{group_name}{acceptance_form}{admin_name}
 * @#cfg_key mail_group_invite_member_message
 */
$LANG['mail_group_invite_member_message'] = 'Dear {friend_name} ,

{user_name} invites you to join {group_name}.

{acceptance_form}

Regards,
{admin_name}';
/**
 * @var string New mail received
 * @cfg_label New mail received subject -- {site_name}
 * @cfg_key new_mail_received_subject
 */
$LANG['new_mail_received_subject'] = 'New mail received - {site_name}';
/**
 * @var string New mail received
 * @cfg_label New mail received content -- {receiver_name}, {sender_name}, {mail_link}, {link}, {site_name}
 * @cfg_key new_mail_received_content
 */
$LANG['new_mail_received_content'] = 'Dear {receiver_name},

You have received a mail from {sender_name},

{mail_link}

To learn more, please visit {site_url}
Regards,
{site_name}';
/**
 * @var string This is used on mailInboxRead.php.This is used while send notification mail
 * @cfg_label Send notification mail subject
 * @cfg_key mail_opened_notify_subject
 */
$LANG['mail_opened_notify_subject'] = 'Message Notification for';
/**
 * @var string This is used on mailInboxRead.php. This is used while send notification mail
 * @cfg_label Send notification mail content
 * @cfg_key mail_opened_notify_message
 */
$LANG['mail_opened_notify_message'] = 'Message Notification:

Your mail message to {name} has been opened on {datetime}';
/**
 * @var string Friends request subject
 * @cfg_label Friends request subject
 * @cfg_key friend_request_subject
 */
$LANG['friend_request_subject'] = 'Friends request from {site_name}';
/**
 * @var string Friends request content
 * @cfg_label Friends request content
 * @cfg_key friend_request_content
 */
$LANG['friend_request_content'] = 'Hi {friend_name},

{user_name} would like to join in your friends circle, click the below link to accept/reject the request.

{be_friends_url}

To learn more, please visit {site_url}
Regards,
{site_name}';
/**
 * @var string Reject Friends
 * @cfg_label Declined to join in your Friends Circle subject -- {user_name}
 * @cfg_key decline_friend_subject
 */
$LANG['decline_friend_subject'] = '{user_name} - declined to join in your Friends Circle';
/**
 * @var string Reject Friends
 * @cfg_label Declined to join in your Friends Circle content -- {friend_name}{user_name}{user_profile_link}
 * @cfg_key decline_friend_content
 */
$LANG['decline_friend_content'] = 'Dear {friend_name},
{user_name} declined to join in your Friends Circle.
{user_profile_link}';
/**
 * @var string Login Reactivation Code Subject
 * @cfg_label Login Reactivation Code Subject -- {site_name}
 * @cfg_key reactivation_login_subject
 */
$LANG['reactivation_login_subject'] = 'Your activation code';
/**
 * @var string Login Reactivation Code Content
 * @cfg_label Login Reactivation Code Content -- {user_name}{activation_link}{link}{site_name}
 * @cfg_key reactivation_login_message
 */
$LANG['reactivation_login_message'] = 'Dear {user_name},

Your activation code. Please click the following link to activate:
{activation_link}

To learn more, please visit {link}

Regards,
{site_name}';
/**
 * @var string Forgot Password Reactivation Code Subject
 * @cfg_label Forgot Password Reactivation Code Subject -- {site_name}
 * @cfg_key reactivation_forgotpass_subject
 */
$LANG['reactivation_forgotpass_subject'] = 'Your activation code';
/**
 * @var string Forgot Password Reactivation Code Content
 * @cfg_label Forgot Password Reactivation Code Content -- {user_name}{activation_link}{link}{site_name}
 * @cfg_key reactivation_forgotpass_message
 */
$LANG['reactivation_forgotpass_message'] = 'Dear {user_name},

Your activation code. Please click the following link to activate:
{activation_link}

To learn more, please visit {link}

Regards,
{site_name}';
/**
 * @var string Forgot Password Code Subject
 * @cfg_label Forgot Password Code Subject
 * @cfg_key forgot_subject
 */
$LANG['forgot_subject'] = 'Forgot Password code';
/**
 * @var string Forgot Password Code Content
 * @cfg_label Forgot Password Code Content - {user_name}{activation_link}{link}{site_name}
 * @cfg_key forgot_message
 */
$LANG['forgot_message'] = 'Dear {user_name},

Your Forgot Password code. Please click the following link to change password:
{activation_link}

To learn more, please visit {link}

Regards,
{site_name}';
/**
 * @var string Invite Friends
 * @cfg_label Request to Join in your Friends Circle subject -- {friend_name}
 * @cfg_key request_friend_subject
 */
$LANG['request_friend_subject'] = '{friend_name} - Request to Join in your Friends Circle';
/**
 * @var string Invite Friends
 * @cfg_label Request to Join in your Friends Circle content -- {user_name}{user_message}{acceptance_form}{friend_name}{friend_name}{friend_profile_link}
 * @cfg_key request_friend_content
 */
$LANG['request_friend_content'] = 'Dear {user_name},
I would like to join in your friends Circle.

{user_message}

Please accept my request.
{acceptance_form}

Regards,
{friend_profile_link}';
/**
 * @var string New friend request received
 * @cfg_label New friend request received subject -- {site_name}
 * @cfg_key new_friend_request_received_subject
 */
$LANG['new_friend_request_received_subject'] = 'New friend request received - {site_name}';
/**
 * @var string New friend request received
 * @cfg_label New friend request received content-- {receiver_name}{sender_name}{mail_link}{link}{site_name}
 * @cfg_key new_friend_request_received_content
 */
$LANG['new_friend_request_received_content'] = 'Dear {receiver_name},
You have received a friend request from {sender_name},

{mail_link}

To learn more, please visit {link}

Regards,
{site_name}';
/**
 * @var string Invite Friends
 * @cfg_label Invite Friends subject -- {user_name}{subject}
 * @cfg_key invite_friend_subject
 */
$LANG['invite_friend_subject'] = '{user_name} - Join with me in {site_name}';
/**
 * @var string Invite Friends
 * @cfg_label Invite Friends content -- {friend_name}{site_name}{link}{user_name}{block_link}
 * @cfg_key invite_friend_content
 */
$LANG['invite_friend_content'] = 'Dear {friend_name},

I am a member of {site_name}.
And i would love to offer you the same opportunity!

{personal_message}

To learn more, please visit {link}
Regards,
{user_name}
{site_name}

You can block {user_name} from sending email by visting:
{block_link}

You can block all {site_name} users from sending you email by visiting:

{block_link}';
/**
 * @var string Default friend added subject
 * @cfg_label Default friend added subject -- {site_name}
 * @cfg_key default_friend_joined_subject
 */
$LANG['default_friend_joined_subject'] = '{friend_name} Welcomes You to {site_name}!';
/**
 * @var string Default friend added
 * @cfg_label Default friend added content-- {friend_name}{site_name}{user_name}
 * @cfg_key default_friend_joined_content
 */
$LANG['default_friend_joined_content'] = 'Hi {user_name},

Welcome to {site_name}, the greatest place to share media and connect with friends!

I\'m {friend_name}, and I am here to help you with {site_name} and to answer any questions you have. As a new member, automatically I become your friend. If there is anything you need, if you just want to say \'Hi\' or if you have recommendations, send me a message anytime!

<b>How Can I Help Out?</b>
<li>You can check out my circle of friends and add them if you wish.</li>
<li>If you have any difficulties navigating the site, let me know.</li>
<li>Or, if you don\'t need my help, you can delete me as a friend whenever you want.</li>

I\'ll see you on {site_name}!

Regards,
{friend_name}';
/**
 * @var string Accept Friends
 * @cfg_label Joined in your Friends Circle subject -- {user_name}
 * @cfg_key accept_friend_subject
 */
$LANG['accept_friend_subject'] = '{user_name} - joined in your Friends Circle';
/**
 * @var string Accept Friends
 * @cfg_label Joined in your Friends Circle content -- {friend_name}{user_name}{user_profile_link}
 * @cfg_key accept_friend_content
 */
$LANG['accept_friend_content'] = 'Dear {friend_name},
{user_name} Joined in your Friends Circle.
{user_profile_link}';
/**
 * @var string New User Welcome Message
 * @cfg_label New User Welcome Message Subject -- {user_name}{site_name}
 * @cfg_key welcome_message_subject
 */
$LANG['welcome_message_subject'] = 'welcome to {site_name}';
/**
 * @var string New User Welcome Message
 * @cfg_label New User Welcome Message Content -- {user_name}{site_name}
 * @cfg_key welcome_message_content
 */
$LANG['welcome_message_content'] = 'Dear {user_name},

welcome to the {site_name}.

Regards,
{site_name}';
/**
 * @#var string Problem in video file
 * @#cfg_label Problem in video file upload subject -- {site_name}
 * @#cfg_key video_invalid_upload_subject
 */
$LANG['video_invalid_upload_subject'] = 'Invalid Uploaded File - {site_name}';
/**
 * @#var string Problem in video file
 * @#cfg_label Problem in video file upload content -- {user_name}{video_title}{link}{site_name}
 * @#cfg_key video_invalid_upload_content
 */
$LANG['video_invalid_upload_content'] = 'Dear {user_name},

Sorry, some problem in your uploaded video file({video_title}),
so we couldnt activate the file

To learn more, please visit {link}
Regards,
{site_name}';
/**
 * @#var string Video file activated
 * @#cfg_label Video file activated subject -- {site_name}
 * @#cfg_key video_activate_subject
 */
$LANG['video_activate_subject'] = 'Video activated - {site_name}';
/**
 * @#var string Video file activated
 * @#cfg_label Video file activated content -- {user_name}{video_title}{video_link}{link}{site_name}
 * @#cfg_key video_activate_content
 */
$LANG['video_activate_content'] = 'Dear {user_name},

Your video file({video_title}) activated,

{video_link}

To learn more, please visit {link}
Regards,
{site_name}';
/**
 * @var string Registration By Admin Subject
 * @cfg_label Registration By Admin Subject -- {site_name}
 * @cfg_key activation_admin_subject
 */
$LANG['activation_admin_subject'] = 'Your activation code';
/**
 * @var string Registration By Admin Content
 * @cfg_label Registration By Admin Content -- {activation_link}{user_name}{password}{link}{site_name}
 * @cfg_key activation_admin_message
 */
$LANG['activation_admin_message'] = 'Dear {user_name},

Your membership created by the site admin.

Information

  User name: {user_name}
  Password: {password}

Your activation code. Please click the following link to activate:
{activation_link}

To learn more, please visit {link}

Regards,
{site_name}';
$LANG['membership_welcome_email_subject']='Your Membership approved';
$LANG['membership_welcome_email_content']='Dear {user_name},

Your membership has been approved, You can now watch the full length video.

To learn more, please visit {link}

Regards,
{site_name}';

/**
 * @#var string report bugs subject
 * @#cfg_label Report bugs subject - VAR_CATEGORY, VAR_SITE_URL
 * @#cfg_key report_bugs_email_subject
 */
$LANG['report_bugs_email_subject'] = 'Report bug - {VAR_CATEGORY} - {VAR_SITE_URL}';
/**
 * @#var string report bugs content
 * @#cfg_label Report bugs content - VAR_SITE_NAME, VAR_REPORTER_NAME, VAR_REPORTER_EMAIL, VAR_SITE_URL, VAR_SITE_IP, VAR_CATEGORY, VAR_CONTENT
 * @#cfg_key report_bugs_email_content
 */
$LANG['report_bugs_email_content'] = 'Hi {VAR_SITE_NAME},

Reporter Name: {VAR_REPORTER_NAME}

Reporter Email: {VAR_REPORTER_EMAIL}

Site Url: {VAR_SITE_URL}

IP: {VAR_SITE_IP}

Bug Category: {VAR_CATEGORY}

{VAR_CONTENT}';

/**
 * @var string Profile Comment Received
 * @cfg_label Profile Comment received  -- {site_name}
 * @cfg_key profile_comment_received_subject
 */
$LANG['profile_comment_received_subject'] = 'You recived a Scrap - {site_name}';
/**
 * @var string Profile Comment Received
 * @cfg_label Profile Commnet content -- {user_name}{profile_link}{link}{site_name}
 * @cfg_key profile_comment_received_content
 */
$LANG['profile_comment_received_content'] = 'Dear {user_name},

You have received a Scrap from ({from_user_name}),

Scrap Message:
	{scrap}

To read more go to the following link:
{profile_link}

To learn more, please visit {link}
Regards,
{site_name}';

?>
