<?php
/*======================================================================*\
|| #################################################################### ||
|| # Mass User-options Change (v. 1.00) - a KF*Network Hack      # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2003 The KuraFire Network          # ||
|| # This file may only be redistributed to vBulletin license holders # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://kurafire.net           ||        http://www.vbulletin.com # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ##########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS ######################
define('CVS_REVISION', '$RCSfile: massuserchange.php,v $ - $Revision: 1.00 $');
define('NO_REGISTER_GLOBALS', 1);

// #################### PRE-CACHE TEMPLATES AND DATA #####################
$phrasegroups = array('cpuser', 'forum', 'user');
$specialtemplates = array();

// ########################## REQUIRE BACK-END ###########################
require_once('./global.php');
require_once('./includes/adminfunctions_user.php');

// TEMPORARY
require_once("./$admincpdir/tmp_muc_phrases.php");


// #######################################################################
// ######################### START MAIN SCRIPT ###########################
// #######################################################################
if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'change';
}


print_cp_header($vbphrase['muc_cpuser_mass_user_change']);


// ###################### Start change ###################################
if ($_REQUEST['do'] == 'change')
{

	// make array for daysprune menu
	$pruneoptions = array(
		'-2' => $vbphrase['muc_cpuser_dont_change'],
		'0' => '- ' . $vbphrase['use_forum_default'] . ' -',
		'1' => $vbphrase['show_threads_from_last_day'],
		'2' => construct_phrase($vbphrase['show_threads_from_last_x_days'], 2),
		'7' => $vbphrase['show_threads_from_last_week'],
		'10' => construct_phrase($vbphrase['show_threads_from_last_x_days'], 10),
		'14' => construct_phrase($vbphrase['show_threads_from_last_x_weeks'], 2),
		'30' => $vbphrase['show_threads_from_last_month'],
		'45' => construct_phrase($vbphrase['show_threads_from_last_x_days'], 45),
		'60' => construct_phrase($vbphrase['show_threads_from_last_x_months'], 2),
		'75' => construct_phrase($vbphrase['show_threads_from_last_x_days'], 75),
		'100' => construct_phrase($vbphrase['show_threads_from_last_x_days'], 100),
		'365' => $vbphrase['show_threads_from_last_year'],
		'-1' => $vbphrase['show_all_threads']
	);


	print_form_header('massuserchange', 'update');


	print_table_header($vbphrase['muc_cpuser_change_useroptions']);

	print_description_row($vbphrase['muc_cpuser_change_page_description']);

	print_membergroup_row($vbphrase['muc_cpuser_exclude_usergroups'], 'membergroups', 3, $user);

	print_table_break();

	print_table_header($vbphrase['muc_cpuser_standard_usersettings']);

	// 'showsignatures'    => 1
	print_yes_no_other_row($vbphrase['display_signatures'], 'options[showsignatures]', $vbphrase['muc_cpuser_dont_change'], -1);
	// 'showavatars'       => 2
	print_yes_no_other_row($vbphrase['display_avatars'], 'options[showavatars]', $vbphrase['muc_cpuser_dont_change'], -1);
	// 'showimages'        => 4
	print_yes_no_other_row($vbphrase['display_images'], 'options[showimages]', $vbphrase['muc_cpuser_dont_change'], -1);
	// 'coppauser'         => 8
	print_yes_no_other_row($vbphrase['coppa_user'], 'options[coppauser]', $vbphrase['muc_cpuser_dont_change'], -1);
	// 'adminemail'        => 16
	print_yes_no_other_row($vbphrase['receive_admin_emails'], 'options[adminemail]', $vbphrase['muc_cpuser_dont_change'], -1);
	// 'showvcard'         => 32
	print_yes_no_other_row($vbphrase['muc_cpuser_show_vcard'], 'options[showvcard]', $vbphrase['muc_cpuser_dont_change'], -1);
	// 'dstauto'           => 64
	print_yes_no_other_row($vbphrase['automatically_detect_dst_settings'], 'options[dstauto]', $vbphrase['muc_cpuser_dont_change'], -1);
	// 'dstonoff'          => 128
	print_yes_no_other_row($vbphrase['dst_currently_in_effect'], 'options[dstonoff]', $vbphrase['muc_cpuser_dont_change'], -1);
	// 'showemail'         => 256
	print_yes_no_other_row($vbphrase['display_email'], 'options[showemail]', $vbphrase['muc_cpuser_dont_change'], -1);
	// 'invisible'         => 512
	print_yes_no_other_row($vbphrase['invisible_mode'], 'options[invisible]', $vbphrase['muc_cpuser_dont_change'], -1);
	// 'showreputation'    => 1024
	print_yes_no_other_row($vbphrase['display_reputation'], 'options[showreputation]', $vbphrase['muc_cpuser_dont_change'], -1);
	// 'receivepm'         => 2048
	print_yes_no_other_row($vbphrase['receive_private_messages'], 'options[receivepm]', $vbphrase['muc_cpuser_dont_change'], -1);
	// 'emailonpm'         => 4096
	print_yes_no_other_row($vbphrase['send_notification_email_when_a_private_message_is_received'], 'options[emailonpm]', $vbphrase['muc_cpuser_dont_change'], -1);

	// postorder is used in combination with user.threadedmode
	// 'postorder'         => 32768,

	// currently unknown why this has its own option and isn't bitwise, but we'll not meddle with that :)
	print_yes_no_other_row($vbphrase['pop_up_notification_box_when_a_private_message_is_received'], 'user[pmpopup]', $vbphrase['muc_cpuser_dont_change'], -1);


	

	print_table_break();

	print_table_header($vbphrase['muc_cpuser_other_settings']);


	$languages = fetch_language_titles_array('', 0);
	$languages[-1] = $vbphrase['muc_cpuser_dont_change'];

	ksort($languages);

	print_select_row($vbphrase['language'], 'user[languageid]', $languages, -1);

	construct_style_chooser($vbphrase['style'], 'user[styleid]', -1, $vbphrase['muc_cpuser_dont_change']);

	print_select_row($vbphrase['default_view_age'], 'user[daysprune]', $pruneoptions, -2);

	print_radio_row($vbphrase['thread_display_mode'], 'user[threaddisplaymode]', array(
		-1 => $vbphrase['muc_cpuser_dont_change'],
		0 => "$vbphrase[linear] - $vbphrase[oldest_first]",
		3 => "$vbphrase[linear] - $vbphrase[newest_first]",
		2 => $vbphrase['hybrid'],
		1 => $vbphrase['threaded']
	), -1, 'smallfont');

	print_radio_row($vbphrase['message_editor_interface'], 'user[showvbcode]', array(
		-1 => $vbphrase['muc_cpuser_dont_change'],
		0 => $vbphrase['do_not_show_editor_toolbar'],
		1 => $vbphrase['show_standard_editor_toolbar'],
		2 => $vbphrase['show_enhanced_editor_toolbar']
	), -1, 'smallfont');

	print_submit_row($vbphrase['muc_cpuser_update_all_users']);
}





// ###################### Start update ###################################
if ($_POST['do'] == 'update')
{
	globalize($_POST, array(
		'user',
		'options',
		'membergroups'
	));

	$usergroupscondition = '';
	$nothingtodo = 1;

	if (is_array($membergroups))
	{
		foreach ($membergroups as $key=>$id)
		{
			$id = intval($id);
			$usergroupscondition .= " AND ($id NOT IN (membergroupids) AND usergroupid != $id)";
		}
	}


	// ############ UPDATE STANDARD OPTIONS FROM $_USEROPTIONS

	// we're not touching 'hasaccessmask' so we're putting that to 1 so we can easily evade that :)
	// we're also not touching 'postorder' yet cos we're doing that later on
	// if you want me to use a different varname instead of $foo, by all means suggest it :p
	$foo = 40960; // == 8192 + 32768
	$optionslist = convert_bits_to_array($foo, $_USEROPTIONS);

	foreach ($optionslist as $optionname=>$val)
	{
		if ($val == 0 AND $options[$optionname] != -1)
		{
			$value = $_USEROPTIONS[$optionname];
			if ($options[$optionname] == 1)
			{ // On: UPDATE user SET options=options + x WHERE NOT(options & x)
				$DB_site->query("UPDATE " . TABLE_PREFIX . "user SET options=options + $value WHERE NOT(options & $value) $usergroupscondition");
				$nothingtodo = 0;
			}
			elseif ($options[$optionname] == 0)
			{ // Off: UPDATE user SET options=options - x WHERE options & x
				$DB_site->query("UPDATE " . TABLE_PREFIX . "user SET options=options - $value WHERE options & $value $usergroupscondition");
				$nothingtodo = 0;
			}
		}
	}



	// ############ UPDATE OTHER SETTINGS

	if ($user['pmpopup'] != -1)
	{
		$nothingtodo = 0;
		if ($user['pmpopup'] == 1)
		{
			$DB_site->query("UPDATE " . TABLE_PREFIX . "user SET pmpopup=" . intval($user['pmpopup']) . " WHERE pmpopup != 2 $usergroupscondition");
		}
		else
		{
			$DB_site->query("UPDATE " . TABLE_PREFIX . "user SET pmpopup=0 WHERE 1=1 $usergroupscondition");
		}
	}


	if ($user['languageid'] != -1)
	{
		$nothingtodo = 0;
		$DB_site->query("UPDATE " . TABLE_PREFIX . "user SET languageid=" . intval($user['languageid']) . " WHERE 1=1 $usergroupscondition");
	}


	if ($user['styleid'] != -1)
	{
		$nothingtodo = 0;
		$DB_site->query("UPDATE " . TABLE_PREFIX . "user SET styleid=" . intval($user['styleid']) . " WHERE 1=1 $usergroupscondition");
	}


	// 'daysprune' is set to -2 for Don't change because -1 is already in use for "Show All Threads"
	if ($user['daysprune'] != -2)
	{
		$nothingtodo = 0;
		$DB_site->query("UPDATE " . TABLE_PREFIX . "user SET daysprune=" . intval($user['daysprune']) . " WHERE 1=1 $usergroupscondition");
	}


	if ($user['threaddisplaymode'] != -1)
	{
		$nothingtodo = 0;
		switch($user['threaddisplaymode'])
		{
			// threaded mode
			case 1:
				$set_postorder    = 0;
				$set_threadedmode = 1;
				break;

			// hybrid mode
			case 2:
				$set_postorder    = 0;
				$set_threadedmode = 2;
				break;

			// linear, newest first
			case 3:
				$set_postorder    = 1;
				$set_threadedmode = 0;
				break;

			// linear, oldest first
			default:
				$set_postorder    = 0;
				$set_threadedmode = 0;
		}

		$value = 32768;
		if ($set_postorder == 1)
		{
			$DB_site->query("UPDATE " . TABLE_PREFIX . "user SET options=options + $value WHERE NOT(options & $value) $usergroupscondition");
		}
		else
		{
			$DB_site->query("UPDATE " . TABLE_PREFIX . "user SET options=options - $value WHERE options & $value $usergroupscondition");
		}

		$DB_site->query("UPDATE " . TABLE_PREFIX . "user SET threadedmode=$set_threadedmode WHERE 1=1 $usergroupscondition");
	}


	if ($user['showvbcode'] != -1)
	{
		$nothingtodo = 0;
		$DB_site->query("UPDATE " . TABLE_PREFIX . "user SET showvbcode=" . intval($user['showvbcode']) . " WHERE 1=1 $usergroupscondition");
	}

	if ($nothingtodo)
	{
		print_stop_message('nothing_to_do');
	}


	define('CP_REDIRECT', "massuserchange.php?$session[sessionurl]do=change");
	print_stop_message('updated_x_successfully', $vbphrase['muc_cpuser_all_users']);

}


print_cp_footer();

/*======================================================================*\
|| ####################################################################
|| # Title   : Mass User-options Change
|| # Version : 1.00
|| # Made by : KuraFire
|| # For     : KuraFire Network, http://kurafire.net/
|| ####################################################################
\*======================================================================*/
?>