<?php

/*======================================================================*\
||	Allow Super Administrators to read Private Messages
||	Install : Upload to admincp/ folder and in browser run as
||    Translation By : marsauae.com
\*======================================================================*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);
define('GET_EDIT_TEMPLATES', 'newpm,insertpm');
define('THIS_SCRIPT', 'pm.php');

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array();

// get special data templates from the datastore
$specialtemplates = array();

// pre-cache templates used by all actions
$globaltemplates = array();

// pre-cache templates used by specific actions
$actiontemplates = array();

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once('./includes/functions_bbcodeparse.php');

// User Is Not SuperAdmin
if (!in_array($bbuserinfo['userid'], preg_split('#\s*,\s*#s', $superadministrators, -1, PREG_SPLIT_NO_EMPTY)))
{
	// Output Header/Message
	print_cp_header('  ');
	print_cp_message('                    config.php');
}

// No Request ID
if (empty($_REQUEST['userid']))
{
	// Output Headers/Data/Footer/Exit
	print_cp_header('   -    ');
	echo '<p><B>              </B></p><p>      <i>http://www.yoursite.com/vb/admincp/pm.php?userid=x</i><br /> x        </p>';
	print_cp_footer();
	exit;
}

// Verify Id, And Assign Variable
$userinfo = verify_id('user', $_REQUEST['userid'], 0, 1);
$userid = &$userinfo['userid'];

// User ID Empty
if (empty($userid))
{
	// Output Headers/Data/Footers/Exit
	print_cp_header('   -    ');
	echo '<p><B>              </B></p><p>      <i>http://www.yoursite.com/vb/admincp/pm.php?userid=x</i><br /> x        </p>';
	print_cp_footer();
	exit;
}
else
{
	// Output Header
	print_cp_header("    : $userinfo[username]");
}

// Folders Array
$folders = array(
	'0' => $vbphrase['inbox'], 
	'-1' => $vbphrase['sent_items']
);

// Folder Not Assigned
if (!empty($bbuserinfo['pmfolders']))
{
	
	$folders += unserialize($bbuserinfo['pmfolders']);
}

// Message Counter Array
$messagecounters = array();

// Build Query
$pmcounts = $DB_site->query("
	SELECT COUNT(*) 
	AS total, 
	folderid
	FROM ".TABLE_PREFIX."pm AS pm
	LEFT JOIN ".TABLE_PREFIX."pmtext AS pmtext 
	USING(pmtextid)
	WHERE userid = $userid
	GROUP BY folderid
");

// Loop Through
while ($pmcount = $DB_site->fetch_array($pmcounts))
{
	// Increment counters
	$messagecounters["$pmcount[folderid]"] = intval($pmcount['total']);
}

// Links Array
$links = array();

// Loop Through
foreach ($folders AS $key => $value)
{
	// Build Array
	$links[] = '<a href="'.THIS_SCRIPT."?userid=$userid&amp;folderid=$key\">$value(".intval($messagecounters["$key"]).")</a>";
}

// Check Request
if (empty($_REQUEST['pmid']))
{
	// Globalize It
	globalize($_REQUEST, array('folderid' => INT));

	// Setup Query
	$pms = $DB_site->query("
		SELECT pm.*, pmtext.*
		".iif($vboptions['privallowicons'], ", icon.title AS icontitle, icon.iconpath")."
		FROM ".TABLE_PREFIX . "pm AS pm
		LEFT JOIN ".TABLE_PREFIX . "pmtext AS pmtext 
		ON(pmtext.pmtextid = pm.pmtextid)
		".iif($vboptions['privallowicons'], "LEFT JOIN ".TABLE_PREFIX."icon AS icon 
		ON(icon.iconid = pmtext.iconid)") . "
		WHERE pm.userid=$userid 
		AND pm.folderid=$folderid
		ORDER BY pmtext.dateline DESC
	");

	// Output Header/Description/Cells
	print_form_header();
	print_table_header("  -- $userinfo[username] -- ".$folders["$folderid"], 4);
	print_description_row(' :-  '.implode(' \ ', $links), 0, 4);
	print_cells_row(array('', ' ', ' ', ''), 1, 'tcat');

	// Loop Through
	while ($pm = $DB_site->fetch_array($pms))
	{
		// Build Arrays
		$pm['senddate'] = vbdate($vboptions['dateformat'], $pm['dateline'], 1);
		$pm['sendtime'] = vbdate($vboptions['timeformat'], $pm['dateline']);
		$pm['receiver_raw'] = unserialize($pm['touserarray']);
		$pm['receiver_key'] = array_keys(&$pm['receiver_raw']);
		$pm['receiver_id'] = &$pm['receiver_key'][0];
		$pm['receiver'] = &$pm['receiver_raw'][$pm['receiver_key'][0]];

		// Output Data
		print_cells_row(array('<a href="'.THIS_SCRIPT."?userid=$userid&amp;folderid=$folderid&amp;pmid=$pm[pmid]\">$pm[title]</a>", "<a href=\"pm.php?userid=$pm[fromuserid]&amp;folderid=$folderid\">$pm[fromusername]</a>","<a href=\"pm.php?userid=$pm[receiver_id]&amp;folderid=$folderid\">$pm[receiver]</a>", "$pm[sendtime]<dfn>$pm[senddate]</dfn>"));
	}

	// No Messages
	if ($DB_site->num_rows($pms) == 0)
	{
		print_description_row('      ', 0, 4);
	}

	// Output Footer
	print_table_footer();
}
else
{
	// Globalize It
	globalize($_REQUEST, array('folderid' => INT, 'pmid' => INT));

	// Setup Query
	$pm = $DB_site->query_first("
		SELECT pm.*, pmtext.*,
		".iif($vboptions['privallowicons'], "icon.title AS icontitle, icon.iconpath,")."
		IF(ISNULL(pmreceipt.pmid), 0, 1) AS receipt, pmreceipt.readtime, pmreceipt.denied
		FROM ".TABLE_PREFIX . "pm AS pm
		LEFT JOIN ".TABLE_PREFIX."pmtext AS pmtext ON(pmtext.pmtextid = pm.pmtextid)
		".iif($vboptions['privallowicons'], "
		LEFT JOIN ".TABLE_PREFIX."icon AS icon ON(icon.iconid = pmtext.iconid)")."
		LEFT JOIN ".TABLE_PREFIX."pmreceipt AS pmreceipt ON(pmreceipt.pmid = pm.pmid)
		WHERE pm.userid=$userid 
		AND pm.pmid=$pmid
	");

	// Setup Array
	$pm['senddate'] = vbdate($vboptions['dateformat'], $pm['dateline'], 1);
	$pm['sendtime'] = vbdate($vboptions['timeformat'], $pm['dateline']);
	$pm['receiver_values'] = array_values(unserialize($pm['touserarray']));
	$pm['receiver'] = &$pm['receiver_values'][0];

	// Output Header/Description/Data/Footer
	print_form_header();
	print_table_header("  -- $userinfo[username] -- " . $folders["$folderid"] . " -- $pm[title]", 3);
	print_description_row(' :- ' . implode(' -- ', $links), 0, 3);
	print_description_row("$pm[fromusername]     $pm[receiver]  : $pm[sendtime]  : $pm[senddate]");
	print_description_row(parse_pm_bbcode($pm['message']));
	print_table_footer();
}

// Finish Footer
print_cp_footer();

// BB Code Parser
function parse_pm_bbcode($bbcode)
{
	global $vboptions, $admincpdir;
	return str_replace('images', '../images', parse_bbcode2($bbcode, $vboptions['privallowhtml'], $vboptions['privallowbbimagecode'], $vboptions['privallowsmilies'], $vboptions['privallowbbcode']));
}

/*======================================================================*\
||	This file is download From : www.marsauae.com/vb
\*======================================================================*/

?>
