<?PHP

##########################
##  AutoRank PHP 2.0.0  ##
##############################################################
##  search.php - Surfer search engine                       ##
##############################################################

include_once('arphp.php');


if( strlen($_GET['key']) > 2 )
{
    $term     = addslashes(stripslashes($_GET['key']));
    $category = $_GET['cat'] != 'Overall' ? "Category='{$_GET['cat']}' AND " : '';
    $userdef  = isset($GLOBALS['USE_SEARCH_USER']) ? "OR Field_1 LIKE '%$term%' OR Field_2 LIKE '%$term%' OR Field_3 LIKE '%$term%'" : '';
    $query    = "SELECT * FROM a_Ranks WHERE $category (Site_Title LIKE '%$term%' OR Description LIKE '%$term%' $userdef) ORDER BY Overall_Rank ASC";
    $page     = $_GET['page'] <= 0 ? 1 : $_GET['page'];

    $begin    = getMicrotime();
    $result   = $DB->Query($query);
    $finish   = getMicrotime();

    $tpl['SEARCH_TIME'] = numFormat($finish-$begin, 3);
    $tpl['NUM_RESULTS'] = $DB->Rows($result);
    $tpl['KEYWORD']     = stripslashes($_GET['key']);
    $tpl['TITLE']       = $GLOBALS['T_SEARCH'];
    
    getPosition($tpl, $page);

    fileParse('_search_header.htmlt', $tpl);

    if( $tpl['NUM_RESULTS'] > 0 )
    {
        $count = 0;
        $html  = fileReadAll("{$GLOBALS['TDIR']}/_search_template.htmlt");
        $DB->Seek($result, ($tpl['START']-1));

        while( $member = $DB->NextRow($result) )
        {
            $count++;
            
            memberTemplate($tpl, $member);

            stringParse($html, $tpl);

            if( $count >= $GLOBALS['RESULTS_PPAGE'] )
            {
                break;
            }
        }
    }

    fileParse('_search_footer.htmlt', $tpl);

    $DB->Free($result);
    $DB->Disconnect();

}
else
{
    derr(1026);
}


#alrookan 2003-10-07 212.138.47.17


function getPosition(&$tpl, &$page)
{

    if( $tpl['NUM_RESULTS'] == 0 )
    {
        $tpl['START'] = 0;
        $tpl['END']   = 0;
    }
    else
    {
        $encodeKey = urlencode(stripslashes($_GET['key']));
        $encodeCat = urlencode(stripslashes($_GET['cat']));

        $tpl['START'] = ($page - 1) * $GLOBALS['RESULTS_PPAGE'] + 1;

        if( $tpl['START'] > $tpl['NUM_RESULTS'] )
        {
            $page = 1;
            $tpl['START'] = 1;
        }

        $tpl['END']   = $page * $GLOBALS['RESULTS_PPAGE'];

        if( $tpl['END'] >= $tpl['NUM_RESULTS'] )
        {
            $tpl['END'] = $tpl['NUM_RESULTS'];
        }
        else
        {
            $tpl['NEXT_PAGE'] = "<a href=\"search.php?key=$encodeKey&cat=$encodeCat&page=" . ($page+1) . "\" class=\"reg\">{$GLOBALS['L_NEXT']}</a>";
        }

        if( $page != 1 )
        {
            $tpl['PREV_PAGE'] = "<a href=\"search.php?key=$encodeKey&cat=$encodeCat&page=" . ($page-1) . "\" class=\"reg\">{$GLOBALS['L_PREVIOUS']}</a>";
        }
    }
}

?>