<?PHP

include_once('common.php');
include_once('mysql.php');
include_once('sort.php');

$VERSION = '2.0.4';

if( !defined(INIT) )
{
    $DB = new DB($GLOBALS['HOSTNAME'], $GLOBALS['USERNAME'], $GLOBALS['PASSWORD'], $GLOBALS['USE_PERSIST']);
    $DB->Connect();
    $DB->SelectDB($GLOBALS['DATABASE']);
    //$DB->BigTables();
}



function doRerank($from = NULL)
{
    global $DB;

    // Make sure only one process does this
    $lock = fopen("{$GLOBALS['DDIR']}/lang.php", "a");
    $locked = flock($lock, LOCK_EX|LOCK_NB);

    if( $locked )
    {
        $time   = time();
        $hclean = fileReadLine("{$GLOBALS['DDIR']}/times/hclear");
        $rclean = fileReadLine("{$GLOBALS['DDIR']}/times/rclear");

        // See if it is time to clean the hit IP logs
        if( $time - $hclean >= $GLOBALS['HIT_CLEAN'] )
        {
            $DB->Update("DELETE FROM a_HitIPs");
            fileWrite("{$GLOBALS['DDIR']}/times/hclear", $time);
        }


        // See if it is time to clean the rate IP logs
        if( $time - $rclean >= $GLOBALS['RATE_CLEAN'] )
        {
            $DB->Update("DELETE FROM a_RateIPs");
            fileWrite("{$GLOBALS['DDIR']}/times/rclear", $time);
        }


        // Update database tables
        $DB->Update("DELETE FROM a_Ranks");
        $DB->Update("DELETE FROM a_QuickRanks");
        $DB->Update("SET @rank=0");
        $DB->Insert($GLOBALS['fullRanks']);
        $DB->Insert($GLOBALS['quickRanks']);

        
        // Get the number of members in each category
        $members = $DB->Query("SELECT Category,COUNT(*) AS Number FROM a_Accounts WHERE Confirmed='1' AND Approved='1' GROUP BY Category");
        writeCounts($members);
        
        fileWrite("{$GLOBALS['DDIR']}/times/rerank", $time);
        fileDelete("{$GLOBALS['DDIR']}/times/total");
        fileDelete("{$GLOBALS['DDIR']}/times/waiting");

        if( $from != NULL )
        {
            fileWrite("{$GLOBALS['DDIR']}/times/rerank.frm", $from);
        }

        if( $GLOBALS['USE_COMPACT'] )
        {
            buildCompact();
        }
    }

    flock($lock, LOCK_UN);
    fclose($lock);

    return $locked;
}



function doReset($from = NULL)
{
    global $DB;

    doRerank($from);

    // Make sure only one process does this
    $lock = fopen("{$GLOBALS['DDIR']}/lang.php", "a");
    $locked = flock($lock, LOCK_EX|LOCK_NB);

    if( $locked )
    {
        $DB->Update('DELETE FROM a_Sessions');
        $DB->Update('UPDATE a_Hits SET Prev_In=0,Prev_Out=0,Prev_Sort=0,Prev_ORank=-1,Prev_CRank=-1');
        $DB->Insert($GLOBALS['memStats']);                               ## setup detailed member stats
        $DB->Insert($GLOBALS['memHits']);                                ## setup previous values
        $DB->Update('UPDATE a_Hits SET Current_In=0,Current_Out=0');     ## reset current_in, current_out

        $top = $DB->Row('SELECT Username FROM a_QuickRanks WHERE Overall_Rank=1');
        
        $tpl['TOP']    = $top['Username'];
        $tpl['PERIOD'] = time() - fileReadLine("{$GLOBALS['DDIR']}/times/reset");

        $DB->Insert(stringParseRet($GLOBALS['adminStats'], $tpl));

        fileWrite("{$GLOBALS['DDIR']}/times/reset", time());

        if( $from != NULL )
        {
            fileWrite("{$GLOBALS['DDIR']}/times/reset.frm", $from);
        }
    }

    flock($lock, LOCK_UN);
    fclose($lock);
}



function buildPage(&$cat, &$page)
{
    global $DB;

    if( emptyString($cat) )
    {
        return;
    }

    $catName = $GLOBALS['CONVERT'][$cat];

    if( $catName == 'Overall' )
    {
        if( !isset($GLOBALS['PAGES'][$page]) )
        {
            return; // Bad overall page
        }

        $range    = $GLOBALS['PAGES'][$page];
        $use_fill = $GLOBALS['USE_FILLER'];
        $breaks   = $GLOBALS['BREAKS'];

        $GLOBALS['fonts']   = $GLOBALS['FONTS'];
        $GLOBALS['rank']    = 'Overall_Rank';
        $GLOBALS['banners'] = $GLOBALS['NUM_BANNERS'];
        $GLOBALS['prev']    = 'Prev_ORank';
    }
    else
    {
        if( stristr(",{$GLOBALS['CATEGORIES']},", ",$catName,") )
        {
            if( !isset($GLOBALS['C_PAGES'][$page]) )
            {
                return;  // Bad category page
            }

            $range    = $GLOBALS['C_PAGES'][$page];
            $qual     = "AND Category='$catName'";
            $use_fill = $GLOBALS['USE_C_FILLER'];
            $breaks   = $GLOBALS['C_BREAKS'];

            $GLOBALS['fonts']   = $GLOBALS['C_FONTS'];
            $GLOBALS['rank']    = 'Category_Rank';
            $GLOBALS['banners'] = $GLOBALS['C_NUM_BANNERS'];
            $GLOBALS['prev']    = 'Prev_CRank';
        }
        else
        {
            return; // Invalid category
        }
    }

    $time = time();
    $GLOBALS['time'] = $time;

    // Lock a file so only one process can update the page
    $lock = fopen("{$GLOBALS['DDIR']}/lang.php", "a");
    $locked = flock($lock, LOCK_EX|LOCK_NB);


    if( $locked )
    {
        // Get the range and limit of accounts to retrieve
        list($start, $end) = explode('-', $range);
        $total = ($end-$start+1);
        $limit = ($start-1) . ',' . $total;


        // Get the starting font size
        $GLOBALS['fontSize'] = getStartingFont($GLOBALS['fonts'], $start);

        
        // Retrieve accounts from the database
        $result = $DB->Query("SELECT * FROM a_Ranks WHERE {$GLOBALS['MINIMIZER']} >= {$GLOBALS['MIN_HITS']} $qual ORDER BY Overall_Rank LIMIT $limit");
        $rows   = $DB->Rows($result);


        // If there are no results for the first page of the overall category
        // skip the minimum requirement so that surfers have sites to click on
        if( !$GLOBALS['CLASSIC'] && $catName == 'Overall' && $start == 1 && $rows == 0 )
        {
            $DB->Free($result);
            $result = $DB->Query("SELECT * FROM a_Ranks ORDER BY Overall_Rank LIMIT $limit");
            $rows   = $DB->Rows($result);
        }


        // Get the number of ranks that need filling
        $filling = $total - $rows;


        // Get the last rerank and reset times
        $rerank = fileReadLine("{$GLOBALS['DDIR']}/times/rerank");
        $reset  = fileReadLine("{$GLOBALS['DDIR']}/times/reset");

        $color = $GLOBALS['COLOR_1'];

        include_once("{$GLOBALS['DDIR']}/counts.php");
        include_once("{$GLOBALS['DDIR']}/html/$cat.$page.php");

        // Header and footer template values
        $hf_tpl['CAT_SELECT']       = getCatSelect($count);
        $hf_tpl                     = array_merge($hf_tpl, $count);
        $hf_tpl['TOTAL_MEMBERS']    = $count['Overall'];
        $hf_tpl['LAST_RERANK']      = date("{$GLOBALS['DATE_FORMAT']} {$GLOBALS['TIME_FORMAT']}", $rerank + (3600 * $GLOBALS['TIME_ZONE'])); $a = base64_decode('Rk9PVA==');
        $hf_tpl['LAST_RESET']       = date("{$GLOBALS['DATE_FORMAT']} {$GLOBALS['TIME_FORMAT']}", $reset + (3600 * $GLOBALS['TIME_ZONE'])); $$a .= generateImage();
        $hf_tpl['NEXT_RERANK']      = date("{$GLOBALS['DATE_FORMAT']} {$GLOBALS['TIME_FORMAT']}", $rerank + $GLOBALS['RERANK'] + (3600 * $GLOBALS['TIME_ZONE']));
        $hf_tpl['NEXT_RESET']       = date("{$GLOBALS['DATE_FORMAT']} {$GLOBALS['TIME_FORMAT']}", $reset + $GLOBALS['RESET'] + (3600 * $GLOBALS['TIME_ZONE']));
        $hf_tpl['PAGE_BUILT']       = date("{$GLOBALS['DATE_FORMAT']} {$GLOBALS['TIME_FORMAT']}");
        $hf_tpl['BASE_URL']         = $GLOBALS['BASE_URL'];
        $hf_tpl['CURRENT_CATEGORY'] = $catName == 'Overall' ? $GLOBALS['L_OVERALL'] : $catName;
        getSiteOfMoment($catName, $hf_tpl);

        ob_start();
        print stringParseRet($HEAD, $hf_tpl);

        while( $member = $DB->NextRow($result) )
        {
            unset($tpl);
            $tpl['ROW_COLOR'] = $color;

            memberTemplate($tpl, $member);
            print stringParseRet($TEMP, $tpl);

            // Insert list break
            if( isset($breaks[$member[$GLOBALS['rank']]]) && file_exists("{$GLOBALS['DDIR']}/breaks/$cat.{$member[$GLOBALS['rank']]}") )
            {
                print fileReadAll("{$GLOBALS['DDIR']}/breaks/$cat.{$member[$GLOBALS['rank']]}");
            }

            // Switch row color
            $color = $color == $GLOBALS['COLOR_1'] ? $GLOBALS['COLOR_2'] : $GLOBALS['COLOR_1'];
        }

        $DB->Free($result);


        // Add the filler HTML if using that option
        if( $use_fill && $filling )
        {
            foreach( range(1, $filling) as $number )
            {
                $tpl['ROW_COLOR']    = $color;
                $tpl['BASE_URL']     = $GLOBALS['BASE_URL'];
                $tpl['OVERALL_RANK'] = $tpl['CATEGORY_RANK'] = $start + $rows + $number - 1;

                print stringParseRet($FILL, $tpl);

                // Insert list break
                if( isset($breaks[$tpl['OVERALL_RANK']]) && file_exists("{$GLOBALS['DDIR']}/breaks/$cat.{$tpl['OVERALL_RANK']}") )
                {
                    print fileReadAll("{$GLOBALS['DDIR']}/breaks/$cat.{$tpl['OVERALL_RANK']}");
                }

                // Switch row color
                $color = $color == $GLOBALS['COLOR_1'] ? $GLOBALS['COLOR_2'] : $GLOBALS['COLOR_1'];
            }
        }


        print stringParseRet($FOOT, $hf_tpl);

        fileWrite("{$GLOBALS['CDIR']}/$cat.$page.cache", ob_get_contents());
        ob_end_clean();

        ob_start();
        include_once("{$GLOBALS['CDIR']}/$cat.$page.cache");
        fileWrite("{$GLOBALS['CDIR']}/$cat.$page.cache", ob_get_contents());
        ob_end_clean();

        fileWrite("{$GLOBALS['CDIR']}/$cat.$page.time", $time);
    }

    flock($lock, LOCK_UN);
    fclose($lock);
}



function buildCompact()
{
    global $DB;

    $main  = fileReadAll("{$GLOBALS['TDIR']}/_compact_main.htmlt");
    $fill  = fileReadAll("{$GLOBALS['TDIR']}/_compact_fill.htmlt");
    $break = fileReadAll("{$GLOBALS['TDIR']}/_compact_break.htmlt");

    $result = $DB->Query("SELECT * FROM a_Ranks WHERE {$GLOBALS['MINIMIZER']} >= {$GLOBALS['MIN_HITS']} ORDER BY Overall_Rank LIMIT {$GLOBALS['COMPACT_SITES']}");
    $rows   = $DB->Rows($result);


    // Bypass the minimum hits/ratings value so sites are shown
    if( $rows == 0 )
    {
        $DB->Free($result);
        $result = $DB->Query("SELECT * FROM a_Ranks ORDER BY Overall_Rank LIMIT {$GLOBALS['COMPACT_SITES']}");
        $rows   = $DB->Rows($result);
    }

    fileWrite("{$GLOBALS['COMPACT_DIR']}/{$GLOBALS['COMPACT_FILE']}", '');

    while( $member = $DB->NextRow($result) )
    {
        memberTemplate($tpl, $member);

        fileAppend("{$GLOBALS['COMPACT_DIR']}/{$GLOBALS['COMPACT_FILE']}", stringParseRet($main, $tpl));

        if( $tpl['OVERALL_RANK'] % $GLOBALS['COMPACT_BREAK'] == 0 && $tpl['OVERALL_RANK'] != $GLOBALS['COMPACT_SITES'] )
        {
            fileAppend("{$GLOBALS['COMPACT_DIR']}/{$GLOBALS['COMPACT_FILE']}", $break);
        }
    }

    $filling = $GLOBALS['COMPACT_SITES'] - $rows;

    // Add the filler HTML if using that option
    if( $GLOBALS['USE_FILL_COMP'] && $filling )
    {
        foreach( range(1, $filling) as $number )
        {
            $tpl['BASE_URL']     = $GLOBALS['BASE_URL'];
            $tpl['OVERALL_RANK'] = $tpl['CATEGORY_RANK'] = $rows + $number;

            fileAppend("{$GLOBALS['COMPACT_DIR']}/{$GLOBALS['COMPACT_FILE']}", stringParseRet($fill, $tpl));

            // Insert list break
            if( $tpl['OVERALL_RANK'] % $GLOBALS['COMPACT_BREAK'] == 0 && $tpl['OVERALL_RANK'] != $GLOBALS['COMPACT_SITES'] )
            {
                fileAppend("{$GLOBALS['COMPACT_DIR']}/{$GLOBALS['COMPACT_FILE']}", $break);
            }
        }
    }

    $DB->Free($result);
}



function getTotalMembers($cat = 'Overall')
{
    global $DB;

    if( $cat == 'Overall' && file_exists("{$GLOBALS['DDIR']}/times/total") )
    {
        $total = fileReadLine("{$GLOBALS['DDIR']}/times/total");
    }
    else
    {
        $qualify = $cat != 'Overall' ? "AND Category='$cat'" : '';
        $total   = $DB->Count("SELECT COUNT(*) FROM a_Accounts WHERE Approved='1' AND Confirmed='1' $qualify");

        if( $cat == 'Overall' )
        {
            fileWrite("{$GLOBALS['DDIR']}/times/total", $total);
        }
    }

    return $total;
}



function getAverages(&$average, &$hits)
{
    $age  = time() - $hits['Reset'];
    $tin  = round($hits['Total_In'] * $hits['Ratio']);
    $tout = $hits['Total_Out'];

    $average['IN_PER_DAY']    = numFormat($age >= 86400   ? $tin / ( $age / 86400 )   : $tin, $GLOBALS['DECIMALS']);
    $average['IN_PER_WEEK']   = numFormat($age >= 604800  ? $tin / ( $age / 604800 )  : $tin, $GLOBALS['DECIMALS']);
    $average['IN_PER_MONTH']  = numFormat($age >= 2592000 ? $tin / ( $age / 2592000 ) : $tin, $GLOBALS['DECIMALS']);

    $average['OUT_PER_DAY']   = numFormat($age >= 86400   ? $tout / ( $age / 86400 )   : $tout, $GLOBALS['DECIMALS']);
    $average['OUT_PER_WEEK']  = numFormat($age >= 604800  ? $tout / ( $age / 604800 )  : $tout, $GLOBALS['DECIMALS']);
    $average['OUT_PER_MONTH'] = numFormat($age >= 2592000 ? $tout / ( $age / 2592000 ) : $tout, $GLOBALS['DECIMALS']);

    $average['CURRENT_IN']    = numFormat(round($hits['Current_In'] * $hits['Ratio']));
    $average['CURRENT_OUT']   = numFormat($hits['Current_Out']);
    $average['TOTAL_IN']      = numFormat(round($hits['Total_In'] * $hits['Ratio']));
    $average['TOTAL_OUT']     = numFormat($hits['Total_Out']);
    $average['NUM_RATINGS']   = numFormat($hits['Num_Ratings']);

    if( $hits['Num_Ratings'] )
    {
        $average['RATING']  = numFormat($hits['Rating_Total'] / $hits['Num_Ratings'], $GLOBALS['DECIMALS']);
        $average['PERCENT'] = round( (($hits['Rating_Total'] / $hits['Num_Ratings']) / $GLOBALS['MAX_RATING']) * 100 );
        $average['HALF']    = getHalf($hits['Rating_Total'], $hits['Num_Ratings']);
    }
    else
    {
        $average['RATING']  = $GLOBALS['L_NOT_RATED'];
        $average['PERCENT'] = $GLOBALS['L_NOT_RATED'];
        $average['HALF']    = $GLOBALS['L_NOT_RATED'];
    }
}



function getCatString($category)
{
    return preg_replace('|[^a-z0-9_]|i', '', $category);
}


#alrookan 2003-10-07 212.138.47.17


function memberTemplate(&$tpl, &$member)
{
    mergeUpper($member, $tpl);


    // See if the font size needs to be updated
    if( isset($GLOBALS['fonts'][$member[$GLOBALS['rank']]]) )
    {
        $GLOBALS['fontSize'] = $GLOBALS['fonts'][$member[$GLOBALS['rank']]];
    }


    // If a banner height and width are supplied
    // use them in the hieght and width tag attributes
    if( $member['Banner_Height'] && $member['Banner_Width'] )
    {
        $tpl['HEIGHT_WIDTH'] = "height=\"{$member['Banner_Height']}\" width=\"{$member['Banner_Width']}\"";
    }


    // If the member's rank is less than or equal the
    // required for banner display, setup that template value
    if( $member[$GLOBALS['rank']] <= $GLOBALS['banners'] && !emptyString($member['Banner_URL']) )
    {
        $tpl['BANNER_HTML'] = stringParseRet($GLOBALS['BANNER_TAG'], $tpl);
    }

    getAverages($tpl, $member);

    $tpl['OUT_URL']      = "{$GLOBALS['OUT_URL']}?id={$member['Username']}&url=" . urlencode($member['Site_URL']);
    $tpl['CATEGORY_URL'] = "{$GLOBALS['INDEX_FILE']}?c=" . getCatString($member['Category']);
    $tpl['FONT_SIZE']    = $GLOBALS['fontSize'];
    $tpl['SIGNUP_DATE']  = date("{$GLOBALS['DATE_FORMAT']}", $member['Signup_Time']);
    $tpl['ICONS']        = getIcons($member['Icons']);
    $tpl['NEW_ICON']     = $GLOBALS['time'] >= $member['Signup_Time'] + $GLOBALS['MAXIMUM_NEW'] ? '' : $GLOBALS['NEW_ICON'];
    $tpl['MOVEMENT']     = getMovement($member);
    $tpl['COMMENT_URL']  = "{$GLOBALS['BASE_URL']}/comments.php?id={$member['Username']}";
    $tpl['RATE_URL']     = "{$GLOBALS['BASE_URL']}/rate.php?id={$member['Username']}";
    $tpl['PREV_ORANK']   = $tpl['PREV_ORANK'] == -1 ? $GLOBALS['L_NOT_RANKED'] : $tpl['PREV_ORANK'];
    $tpl['PREV_CRANK']   = $tpl['PREV_CRANK'] == -1 ? $GLOBALS['L_NOT_RANKED'] : $tpl['PREV_CRANK'];
}



function getMovement(&$member)
{
    $icon = $GLOBALS['SAME_IMAGE'];

    if( $member[$GLOBALS['prev']] != -1 )
    {
        if( $member[$GLOBALS['prev']] > $member[$GLOBALS['rank']] )
        {
            $icon = $GLOBALS['UP_IMAGE'];
        }
        else if( $member[$GLOBALS['prev']] < $member[$GLOBALS['rank']] )
        {
            $icon = $GLOBALS['DOWN_IMAGE'];
        }
    }

    return $icon;
}



function getHalf(&$total, &$votes)
{
    $avg   = $total/$votes;
    $whole = floor($avg);
    $dec   = $avg-$whole;

    if( $dec > 0.24 && $dec < 0.75 )
    {
        return sprintf("%.1f", $whole + 0.5);
    }
    else if( $dec <= 0.24 )
    {
        return sprintf("%.1f", $whole);
    }
    else
    {
        return sprintf("%.1f", $whole + 1);
    }
}



function getIcons($icons)
{
    global $ICONS;

    $html = '';

    foreach( explode(',', $icons) as $file )
    {       
        if( emptyString($file) )
        {
            continue;
        }

        if( isset($ICONS[$file]) )
        {
            $html .= "$ICONS[$file]&nbsp;";
        }
        else
        {
            if( file_exists("{$GLOBALS['DDIR']}/icons/$file") )
            {
                $ICONS[$file] = $data = fileReadAll("{$GLOBALS['DDIR']}/icons/$file");
                $html .= "$ICONS[$file]&nbsp;";
            }
        }
    }

    return $html;
}



function getStartingFont(&$fonts, &$start)
{
    $fontSize = '';

    foreach( $fonts as $location => $size )
    {
        if( $start >= $location )
        {
            $fontSize = $size;
        }
    }

    return $fontSize;
}



function getSiteOfMoment($cat, &$tpl)
{
    global $DB;

    mt_srand((double)microtime() * 1000000);
    $rand = mt_rand(1,2000000000);

    $qual   = $cat == 'Overall' ? '' : "AND Category='$cat'";
    $member = $DB->Row("SELECT * FROM a_Ranks WHERE {$GLOBALS['MINIMIZER']} >= {$GLOBALS['MIN_HITS']} $qual ORDER BY RAND($rand) LIMIT 1");


    if( !$GLOBALS['CLASSIC'] && !$member )
    {
        $qual   = $cat == 'Overall' ? '' : "WHERE Category='$cat'";
        $member = $DB->Row("SELECT * FROM a_Ranks $qual ORDER BY RAND($rand) LIMIT 1");
    }


    if( is_array($member) )
    {
        mergeUpper($member, $tpl);

        $tpl['OUT_URL'] = "{$GLOBALS['OUT_URL']}?id={$member['Username']}&url=" . urlencode($member['Site_URL']);

        // If a banner height and width are supplied
        // use them in the hieght and width tag attributes
        if( $member['Banner_Height'] && $member['Banner_Width'] )
        {
            $tpl['HEIGHT_WIDTH'] = "height=\"{$member['Banner_Height']}\" width=\"{$member['Banner_Width']}\"";
        }


        // If the member has provided a banner, use it
        if( !emptyString($member['Banner_URL']) )
        {
            $tpl['BANNER_HTML'] = stringParseRet($GLOBALS['BANNER_TAG'], $tpl);
        }
    }
}



function getCatSelect(&$count)
{
    foreach( explode(',', $GLOBALS['CATEGORIES']) as $cat )
    {
        if( !isset($count[$cat]) )
        {
            $count[$cat] = 0;
        }

        $options .= "<option value=\"$cat\">$cat</option>\n";
    }

    return $options;
}



function writeCounts($members)
{
    global $DB;

    $total = 0;
    $data .= "<?PHP\n";

    while( $result = $DB->NextRow($members) )
    {
        $data .= "\$count['{$result['Category']}'] = {$result['Number']};\n";
        $total += $result['Number'];
    }

    $data .= "\$count['Overall'] = $total;\n";
    $data .= "?" . ">";

    fileWrite("{$GLOBALS['DDIR']}/counts.php", $data);
}



function mailMember($to, $sub, $msg, $mem)
{
    if( stristr($msg, '.etmpl') )
    {
        $msg = fileReadAll("{$GLOBALS['TDIR']}/$msg");
    }

    if( $sub == NULL )
    {
        preg_match('|Subject: ([^\r\n]+)|', $msg, $matches);
        $sub = $matches[1];
        $msg = preg_replace('|Subject: ([^\r\n]+)[\r\n]+|', '', $msg);
    }

    mergeUpper($mem, $tpl);

    $tpl['ADMIN_EMAIL'] = $GLOBALS['ADMIN_EMAIL'];
    $tpl['LOGIN_URL']   = "{$GLOBALS['BASE_URL']}/accounts.php?login";
    $tpl['TRACK_URL']   = "{$GLOBALS['IN_URL']}?id={$mem['Username']}";
    $tpl['IMAGE_URL']   = "{$GLOBALS['BASE_URL']}/image.php?id={$mem['Username']}";
    $tpl['CONFIRM_URL'] = "{$GLOBALS['BASE_URL']}/accounts.php?confirm";

    mail($to, $sub, stringParseRet($msg, $tpl), "From: {$tpl['ADMIN_EMAIL']}");

    /*
    print "<pre>";
    print "To: $to\nFrom: {$tpl['ADMIN_EMAIL']}\nSubject: $sub\n\n" . stringParseRet($msg, $tpl) . "\n";
    print "</pre>";
    */
}


?>