#!/usr/bin/perl

use lib '.';
use cgiworks;

$|++;

print "Content-type: text/html\n\n";
$HEADER = 1;

eval
{
    require 'arp.pl';
    main();
};

err("$@", 'autorankpro.cgi') if( $@ );
exit;


sub main
{
    print "<pre>\n";

    if( $VERSION )
    {
        print "Located AutoRank Pro v$VERSION Installation\n\n\n";

        fwrite("$DDIR/arp-sql.txt", '');
        fwrite("$DDIR/arp-data.txt", '');

        members();
        blacklist();
        other();


        print "\n\nThe conversion process has been completed.\nPlease continue with the next step in the upgrade documentation.\n";
    }
    else
    {
        print "Could not locate AutoRank Pro v4.0.x Installation\n";
    }

    print "</pre>\n";
}



sub members
{
    my $mems = dread("$DDIR/members", '\.dat$');

    print "Converting Your Members.......................";

    for( @{$mems} )
    {
        my $data  = $_;
        my $count = $_;
        $count =~ s/\.dat$/\.cnt/gi;

        $member{'Username'} = $data;
        $member{'Username'} =~ s/\.dat$//gi;


        ( 
        $member{'Email'},
        $member{'Site_URL'},
        $member{'Banner_URL'},
        $member{'Banner_Height'},
        $member{'Banner_Width'},
        $member{'Recip_URL'},
        $member{'Site_Title'},
        $member{'Description'},
        $member{'Category'},
        $member{'Icons'},
        $member{'Signup_Time'},
        $member{'Reset'},
        $member{'Ratio'},
        $member{'Prev_Sort'},
        $member{'Prev_In'},
        $member{'Prev_Out'},
        $member{'Prev_ORank'},
        $member{'Prev_CRank'},
        $member{'Password'},
        $member{'-'},
        $member{'Suspended'},
        $member{'Locked'},
        $member{'-'},
        $member{'Field_1'},
        $member{'Field_2'},
        $member{'Field_3'} 
        ) = split(/\|/, freadline("$DDIR/members/$data"));


        (
        $member{'Current_In'},
        $member{'Current_Out'},
        $member{'Total_In'},
        $member{'Total_Out'},
        $member{'-'},
        $member{'-'},
        $member{'-'},
        $member{'-'},
        $member{'-'},
        $member{'Inactive'}
        ) = split(/\|/, freadline("$DDIR/members/$count"));


        $member{'Category'}   = 'General' if( !$member{'Category'} );
        $member{'Prev_ORank'} = '-1' if( $member{'Prev_ORank'} eq 'NA' );
        $member{'Prev_CRank'} = '-1' if( $member{'Prev_CRank'} eq 'NA' );
        $member{'Prev_Sort'}  = 0 if( $member{'Prev_Sort'} eq 'NA' );
        $member{'Prev_In'}    = 0 if( $member{'Prev_In'} eq 'NA' );
        $member{'Prev_Out'}   = 0 if( $member{'Prev_Out'} eq 'NA' );


        for( keys %member )
        {
            chomp($member{$_});
            $member{$_} =~ s/\\//gi;
            $member{$_} =~ s/'/\\'/gi;
        }


        $a_Accounts = 
        "INSERT INTO a_Accounts VALUES (" .
        "'$member{'Username'}'," .
        "'$member{'Email'}'," .
        "'$member{'Site_URL'}'," .
        "'$member{'Banner_URL'}'," .
        "'$member{'Banner_Height'}'," .
        "'$member{'Banner_Width'}'," .
        "'$member{'Recip_URL'}'," .
        "'$member{'Site_Title'}'," .
        "'$member{'Description'}'," .
        "'$member{'Category'}'," .
        "'$member{'Icons'}'," .
        "'$member{'Signup_Time'}'," .
        "'$member{'Ratio'}'," .
        "'$member{'Password'}'," .
        "''," .
        "'1'," .
        "'1'," .
        "'$member{'Suspended'}'," .
        "'$member{'Locked'}'," .
        "'$member{'Reset'}'," .
        "'$member{'Field_1'}'," .
        "'$member{'Field_2'}'," .
        "'$member{'Field_3'}' );";


        $a_Hits =
        "INSERT INTO a_Hits VALUES (" .
        "'$member{'Username'}'," .
        "'$member{'Current_In'}'," .
        "'$member{'Current_Out'}'," .
        "'$member{'Total_In'}'," .
        "'$member{'Total_Out'}'," .
        "'$member{'Prev_In'}'," .
        "'$member{'Prev_Out'}'," .
        "'$member{'Prev_Sort'}'," .
        "'$member{'Prev_ORank'}'," .
        "'$member{'Prev_CRank'}'," .
        "'$member{'Inactive'}' );";

        
        $a_Ratings = 
        "INSERT INTO a_Ratings VALUES (" .
        "'$member{'Username'}'," .
        "0," .
        "0 );";


        $a_HitCheats = 
        "INSERT INTO a_HitCheats VALUES (" .
        "'$member{'Username'}'," .
        "0," .
        "0," .
        "0," .
        "0," .
        "0," .
        "0," .
        "0," .
        "0," .
        "0 );";


        $a_RateCheats = 
        "INSERT INTO a_RateCheats VALUES (" .
        "'$member{'Username'}'," .
        "0," .
        "0," .
        "0," .
        "0," .
        "0," .
        "0," .
        "0," .
        "0 );";


        fappend("$DDIR/arp-sql.txt", "$a_Accounts\n");
        fappend("$DDIR/arp-sql.txt", "$a_Hits\n");
        fappend("$DDIR/arp-sql.txt", "$a_Ratings\n");
        fappend("$DDIR/arp-sql.txt", "$a_HitCheats\n");
        fappend("$DDIR/arp-sql.txt", "$a_RateCheats\n");
    }

    print "Done (" . scalar( @{$mems} ) . ")\n";
}



sub blacklist
{
    print "Converting Your Banned Items..................";
  
    my $line;

    for( @{freadall("$DDIR/dbs/email.ban")} )
    {
        chomp($line = $_);
        $line =~ s/'/\\'/gi;
        fappend("$DDIR/arp-sql.txt", "INSERT INTO a_Bans VALUES ( 'E-mail', '$line', '0' );\n") if( $line ne '' );
    }


    for( @{freadall("$DDIR/dbs/word.ban")} )
    {
        chomp($line = $_);
        $line =~ s/'/\\'/gi;
        fappend("$DDIR/arp-sql.txt", "INSERT INTO a_Bans VALUES ( 'Word', '$line', '0' );\n") if( $line ne '' );
    }


    for( @{freadall("$DDIR/dbs/url.ban")} )
    {
        chomp($line = $_);
        $line =~ s/'/\\'/gi;
        fappend("$DDIR/arp-sql.txt", "INSERT INTO a_Bans VALUES ( 'URL', '$line', '0' );\n") if( $line ne '' );
    }


    for( @{freadall("$DDIR/dbs/IP.ban")} )
    {
        chomp($line = $_);
        $line =~ s/'/\\'/gi;
        fappend("$DDIR/arp-sql.txt", "INSERT INTO a_Bans VALUES ( 'IP', '$line', '0' );\n") if( $line ne '' );
    }

    print "Done\n";
}



sub other
{
    print "Finalizing conversion.........................";
           
    for( @{dread("$DDIR/icons", '^[^.]')} )
    {
        my $icon = $_;

        if( -f "$DDIR/icons/$icon" )
        {
            fappend("$DDIR/arp-data.txt", "Database: icons/$icon\n<<<" . ${freadalls("$DDIR/icons/$icon")} . ">>>\n");
        }
    }

    fappend("$DDIR/arp-data.txt", "Database: times/start\n<<<" . freadline("$DDIR/times/start") . ">>>\n");
    fappend("$DDIR/arp-data.txt", "Database: times/treset\n<<<" . freadline("$DDIR/times/treset") . ">>>\n"); 

    print "Done\n";
}
